# -*- Mode: perl; indent-tabs-mode: nil -*-
#
# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is the Bugzilla Bug Tracking System.
#
# The Initial Developer of the Original Code is Netscape Communications
# Corporation. Portions created by Netscape are
# Copyright (C) 1998 Netscape Communications Corporation. All
# Rights Reserved.
#
# Contributor(s): Terry Weissman <terry@mozilla.org>
#                 Dawn Endico <endico@mozilla.org>
#                 Dan Mosedale <dmose@mozilla.org>
#                 Joe Robins <jmrobins@tgix.com>
#                 Jake <jake@acutex.net>
#

# This file defines all the parameters that we have a GUI to edit within
# Bugzilla.

# ATTENTION!!!!   THIS FILE ONLY CONTAINS THE DEFAULTS.
# You cannot change your live settings by editing this file.
# Only adding new parameters is done here.  Once the parameter exists, you 
# must use %baseurl%/editparams.cgi from the web to edit the settings.

use diagnostics;
use strict;

# Shut up misguided -w warnings about "used only once".  For some reason,
# "use vars" chokes on me when I try it here.

sub defparams_pl_sillyness {
    my $zz;
    $zz = %::param_checker;
    $zz = %::param_desc;
    $zz = %::param_type;
}

sub WriteParams {
    foreach my $i (@::param_list) {
        if (!defined $::param{$i}) {
            $::param{$i} = $::param_default{$i};
            if (!defined $::param{$i}) {
                die "No default parameter ever specified for $i";
            }
        }
    }

    my $tmpname = "data/params.$$";
    open(FID, ">$tmpname") || die "Can't create $tmpname";
    my $v = $::param{'version'};
    delete $::param{'version'};  # Don't write the version number out to
                                # the params file.
    print FID GenerateCode('%::param');
    $::param{'version'} = $v;
    print FID "1;\n";
    close FID;
    rename $tmpname, "data/params" || die "Can't rename $tmpname to data/params";
    ChmodDataFile('data/params', 0666);
}
    

sub DefParam {
    my ($id, $desc, $type, $default, $checker) = (@_);
    push @::param_list, $id;
    $::param_desc{$id} = $desc;
    $::param_type{$id} = $type;
    $::param_default{$id} = $default;
    if (defined $checker) {
        $::param_checker{$id} = $checker;
    }
}


sub check_numeric {
    my ($value) = (@_);
    if ($value !~ /^[0-9]+$/) {
        return "must be a numeric value";
    }
    return "";
}
    
sub check_shadowdb {
    my ($value) = (@_);
    $value = trim($value);
    if ($value eq "") {
        return "";
    }
    SendSQL("SHOW DATABASES");
    while (MoreSQLData()) {
        my $n = FetchOneColumn();
        if (lc($n) eq lc($value)) {
            return "ǡ١$n ϴ¸ߤޤ⤷ˤ̾ХååѤ˻ѤʤСĤƺǡ١ɤذܤƤľƤ";
        }
    }
    SendSQL("CREATE DATABASE $value");
    SendSQL("INSERT INTO shadowlog (command) VALUES ('SYNCUP')", 1);
    return "";
}

@::param_list = ();



# OK, here are the definitions themselves.
#
# The type of parameters (the third parameter to DefParam) can be one
# of the following:
#
# t -- A short text entry field (suitable for a single line)
# l -- A long text field (suitable for many lines)
# b -- A boolean value (either 1 or 0)

DefParam("maintainer",
         " Bugzilla δԤΥ᡼륢ɥ쥹",
         "t",
         'THE MAINTAINER HAS NOT YET BEEN SET');

DefParam("urlbase",
         "Bugzilla  URL ˲äURL",
         "t",
         "http://cvs-mirror.mozilla.org/webtools/bugzilla/",
         \&check_urlbase);

sub check_urlbase {
    my ($url) = (@_);
    if ($url !~ m:^http.*/$:) {
        return "http ǻϤޤꥹå(/)ǽ롢 URL ɽǽ񤤤Ƥ";
    }
    return "";
}

DefParam("cookiepath", 
  "Bugzilla ֤ document root ʲˤǥ쥯ȥѥå (/) ǻϤޤ뤳ȤǧƤ<!--
Directory path under your document root that holds your Bugzilla installation. Make sure to begin with a /. -->",
  "t",
  "/");

DefParam("usequip",
        "ˤȡBugzilla ϸ̥ꥹȤξ˥إåɥ饤 (quip) ɽޤإåɥ饤ϥ桼ɲä뤳ȤǤޤ",
        "b",
        1);

# Added parameter - JMR, 2/16/00
DefParam("usebuggroups",
         "ˤȡBugzilla ϳƥץȤ˴ϢХ롼פ褦ˤʤꡢ˻Ѥޤ<!--
If this is on, Bugzilla will associate a bug group with each product in the database, and use it for querying bugs.-->",
         "b",
         0); 

# Added parameter - JMR, 2/16/00
DefParam("usebuggroupsentry",
         "ˤȡץȥХ롼פѤơХϿǤ桼¤ޤusebuggroups ⥪ˤƤ",
         "b",
         0); 

DefParam("shadowdb",
         "ɤ߽ФѤΥԡȤʤ롢̤Υǡ١̾ꤷޤΤȤˤꡢĹ٤ɤ߽ФϤDBФƹԤ褦ˤʤꡢΤۤDBåʤƤ褦ˤʤޤ<br>ʸϤȡ̾ǥǡ١ޤ߻ѤƤǡ١̾ϻꤷʤǤ!",
         "t",
         "",
         \&check_shadowdb);

DefParam("queryagainstshadowdb",
         "򥪥ˤơ shadowdb åȤƤȡϥɥDB˹Ԥޤ",
         "b",
         0);
         

# Adding in four parameters for LDAP authentication.  -JMR, 7/28/00
DefParam("useLDAP",
         "ˤȡ桼ǧڤˡBugzilla ǡ١ LDAP ǥ쥯ȥѤޤ(桼ץեϥǡ١Τۤ˳Ǽޤ᡼륢ɥ쥹ˤä LDAP 桼Ⱦȹ礵ޤ)",
         "b",
         0);


DefParam("LDAPserver",
         "LDAPФΥɥ쥹(:ݡ)(: ldap.company.com ޤ ldap.company.com:ݡֹ)",
         "t",
         "");


DefParam("LDAPBaseDN",
         "桼ǧڤФ١DN(̾)(: \"ou=People,o=Company\")",
         "t",
         "");


DefParam("LDAPmailattribute",
         "LDAPǥ쥯ȥǡ᡼륢ɥ쥹ޤ桼°̾",
         "t",
         "mail");
#End of LDAP parameters


DefParam("mostfreqthreshold",
         "<A HREF=\"duplicates.cgi\">Ǥˤ𤵤ХΥڡ</a>˷Ǻܤ뤿˺ɬפʥХνʣ⤷礭ʥǡ١ꡢΥڡɤ߹Τ˻֤ΤǤСο䤷ƤߤƤ",
         "t",
         "2");


DefParam("mybugstemplate",
         "ֻΥХפΥꥹȤƤӽФ URL%userid% ϥ桼Υ֤̾ޤ",
         "t",
         "buglist.cgi?bug_status=NEW&amp;bug_status=ASSIGNED&amp;bug_status=REOPENED&amp;email1=%userid%&amp;emailtype1=exact&amp;emailassigned_to1=1&amp;emailreporter1=1");
    

DefParam("shutdownhtml",
         "ιܤǤʤȤϡBugzilla ϤޤäѤǤʤʤꡢˤΥƥȤ Bugzilla ΤɤΥڡǤɽޤ",
         "l",
         "");

DefParam("sendmailnow",
         "ˤȡBugzilla  sendmail ˤɤΥ᡼⤹դ褦ؼޤ⤷¿Υ桼ˤ뤿Υ᡼ΥȥեåȤˤСBugzillaư٤ʤǤ礦BugzillaΰϤȤˤᤷޤ",
         "b",
         0);

DefParam("passwordmail",
q{ѥΤΥ᡼ʸǤΥƥ %mailaddress% ϤοͤΥ᡼륢ɥ쥹Ѵޤ%login% ϤοͤΥ̾Ѵޤ(Ƥϥ᡼륢ɥ쥹ƱǤ) %<i>ʳ</i>% ϡΥڡ줿ѥ᡼Ѵޤ},
         "l",
         q{From: bugzilla-daemon
To: %mailaddress%
Subject: Your Bugzilla password.

Bugzilla ѤˤϡʲѤƤ:

 ᡼륢ɥ쥹: %login%
     ѥ: %password%

ѥɤѹϰʲعԤäƤ:

 %urlbase%userprefs.cgi

-------------------------------------------------------------------

To use the wonders of Bugzilla, you can use the following:

 E-mail address: %login%
       Password: %password%

 To change your password, go to:
 %urlbase%userprefs.cgi
});


DefParam("newchangedmail",
q{ХѲäȤ᡼ʸǤʸΡ%to% ϥ᡼֤ͤޤ%bugid% ϥХֹˤʤޤ%diffs% ϥХݡȤѹǤ%neworchanged$ ϿХξ "New" ˡ¸Хѹξ϶ʸˤʤޤ%summary% ϤΥХǤ%reasonsheader% ϲΤοͤ᡼äΤȤͳʷ˽񤫤줿ꥹȤˤʤޤϥ᡼إå (Ȥ X-Bugzilla-Reason) ˸Ƥޤ%reasonsbody% ϥ桼Υ᡼äͳ %reasonsheader% ʬפ񤫤Ƥޤ%<i>ʳ</i>% ϡΥڡ줿ѥ᡼Ѵޤ},
         "l",
"From: bugzilla-daemon
To: %to%
Subject: [Bug %bugid%] %neworchanged%%summary%
X-Bugzilla-Reason: %reasonsheader%

%urlbase%show_bug.cgi?id=%bugid%

%diffs%



%reasonsbody%");



DefParam("whinedays",
         "ХݡȤ NEW ΥơǼդΤޤ޲֤Ƥδ¤᤮顢cronjob ôԤ˷ٹ᡼ޤ",
         "t",
         7,
         \&check_numeric);


DefParam("whinemail",
         "Ĥʤޤ <b>whinedays</b>ۤ NEW Хͤ᡼ʸΥƥ桢%email% ôԤΥ᡼륢ɥ쥹֤ޤ%userid% ôԤΥ̾(̤ϥ᡼륢ɥ쥹Ʊ)֤ޤ%<i>ʳ</i>% ϤΥڡ褦֤ޤ<p> Υå From: ɥ쥹ܤƤΤϤ褤ͤǤ⤷᡼뤬äƤСôԤΥɥ쥹ȵդȤǤ뤫Ǥ",
         "l",
         q{From: %maintainer%
To: %email%
Subject: Your Bugzilla buglist needs attention.

  [Υ᡼ϼưŪƤޤ]

  BugzillaХƥ (%urlbase%) ˡʤôХ
  𤵤Ƥޤ
  
   NEW ֤Τޤޡ%whinedays% вᤷޤ
  ΤȤǧƹưȤäƤ

  ϰŪˤϼ3ĤΤΤ줫ˤʤޤ:

  (1) ΥХˤн褹뤳Ȥˤʤ (Х INVALID Ȥ
      ʤ)˽Ƥ

  (2) ʬн褹ХǤϤʤȹͤʤ顢¾οͤ˳ľ
      Ƥ
      (ҥ: ïô뤫ʬʤä顢Ŭڤʥݡͥ
      ӡ֥ݡͥȤνôԤ˺ƳƤפ
      򤷤Ƥ)

  (3) ΥХϼʬôǤϤȻפɡǤʤ
      Ȥϡ֥ХץޥɤȤäƤ

  ٤Ƥ NEWХΥꥹȤˤϡʲ URL ѤƤ

    %urlbase%buglist.cgi?bug_status=NEW&assigned_to=%userid%

  뤤ϡŪʸڡѤ뤳ȤǤޤ

    %urlbase%query.cgi

  źդƤΤϡ콵ְʾĤ
  ʤôƤ NEW Х URL Ǥ
  ΥХн褹ޤǡ󤳤Υåޤ!

});



DefParam("defaultquery",
          "ХڡǤκǽΥǥեȸǤURLǥѥ᡼ꤷƤΤɤߤˤǤSorry!",
         "t",
         "bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED&emailassigned_to1=1&emailassigned_to2=1&emailreporter2=1&emailcc2=1&emailqa_contact2=1&order=%22Importance%22");


DefParam("letsubmitterchoosepriority",
         "򥪥ˤȡХ𤹤̤ͤͥǤ褦ˤʤޤդˤȡǻꤵ줿̤ͥˤʤޤ",
         "b",
         1);


sub check_priority {
    my ($value) = (@_);
    GetVersionTable();
    if (lsearch(\@::legal_priority, $value) < 0) {
        return "̤ͥꤷƤΤ٤ޤ: " .
            join(", ", @::legal_priority);
    }
    return "";
}

DefParam("defaultpriority",
         "ϿХ˥åȤ̤ͥǤ",
         "t",
         "P2",
         \&check_priority);


DefParam("usetargetmilestone",
         "åȥޥ륹ȡιܤѤޤ?",
         "b",
         0);

DefParam("nummilestones",
         "åȥޥ륹ȡѤˡĤΥޥ륹ȡɽ뤫ꤷޤ",
         "t",
         10,
         \&check_numeric);

DefParam("curmilestone",
         "åȥޥ륹ȡѤˡߺоݤȤʤäƤޥ륹ȡꤷޤ",
         "t",
         1,
         \&check_numeric);

DefParam("musthavemilestoneonaccept",
         "åȥޥ륹ȡѤˡ֥Хץޥɤ֤Ȥϥޥ륹ȡɬåȤƤ٤Ǥ?",
         "b",
         0);

DefParam("useqacontact",
         "QA 󥿥ȤιܤѤޤ?",
         "b",
         0);

DefParam("usestatuswhiteboard",
         "ۥ磻ȥܡɤѤޤ?",
         "b",
         0);

DefParam("usebrowserinfo",
         "ХݡȤ OSȥץåȥեˡ桼ѤƤ Web֥饦ξϤޤ?",
         "b",
         1);

DefParam("usedependencies",
         "¸ط (Х¾ΥХ˰¸ƤȤޡդǤ褦ˤʤ) Ѥޤ?",
         "b",
         1);

DefParam("usevotes",
         "ХФɼǤ褦ˤޤ? ιܤ̤ȯ뤿ˤϡ<a href=\"editproducts.cgi\">ץԽڡ</a> ǡץȤȤκɼ 0 ʳѹɬפޤ",
         "b",
         1);

DefParam("webdotbase",
         "¸طˤХ򥰥ղ뤳ȤǤޤΥѥ᡼ʲΤɤ줫˥åȤޤ:
<ul>
<li>\'dot\' ޥɤؤδʥեѥ (<a href=\"http://www.graphviz.org\">GraphViz</a> ˴ޤޤ륳ޥɤǡǥԤʤޤ)
</li>
<li> ⡼Ȥǥդ <a href=\"http://www.research.att.com/~north/cgi-bin/webdot.cgi\">webdot ѥå</a>֤줿ؤ URL ץե
</li>
<li>ϰ¸طդԲĤˤ롣</li>
</ul>
ǥեͤïǤ⥢Ǥ webdot ФˤʤäƤޤͤѹȤϡwebdot Ф data/webdot ǥ쥯ȥ꤫եɤ߹ळȤΤǤ褦ˤƤƤApache ˤƤϡ.htaccess եԽвǽˤʤޤ̤ΥƥǤˡϰۤʤޤ.htaccess ե뤬ʤʤäȤϡchecksetup.pl ¹ԤƺƤ",
         "t",
         "http://www.research.att.com/~north/cgi-bin/webdot.cgi/%urlbase%",
         \&check_webdotbase);

sub check_webdotbase {
    my ($value) = (@_);
    $value = trim($value);
    if ($value eq "") {
        return "";
    }
    if($value !~ /^https?:/) {
        if(! -x $value) {
            return "եѥ \"$value\" ¹ԥեǤϤޤ󡣥ǥդĤʤ顢'dot' ؤδʥեѥꤷƤ";
        }
        # Check .htaccess allows access to generated images
        if(-e "data/webdot/.htaccess") {
            open HTACCESS, "data/webdot/.htaccess";
            if(! grep(/png/,<HTACCESS>)) {
                print "¸طդβ˥Ǥʤ֤ˤʤäƤޤdata/webdot/.htaccess ơchecksetup.pl Ƽ¹ԤƺľƤ\n";
            }
            close HTACCESS;
        }
    }
    return "";
}

DefParam("expectbigqueries",
         "򥪥ˤȡmysql ФƥХ򤹤 <tt>set option SQL_BIG_TABLES=1</tt> ޤȾ٤ʤޤʰơ֥ɬפȤ褦׵ФƤ <tt>The table ### is full</tt> Υ顼Фʤʤޤ",
         "b",
         0);

DefParam("emailregexp",
         '᡼륢ɥ쥹ɾ˻ѤɽޤǥեȤǤϡʥ᡼륢ɥ쥹˰פޤ¾ˤ⡢@ ̵桼̾ ("local usernames, no @ allowed.")  <tt>^[^@, ]*$</tt> Ϥ褯Ȥޤ',
         "t",
         q:^[^@]+@[^@]+\\.[^@]+$:);

DefParam("emailregexpdesc",
         "ˤϡ<tt>emailregexp</tt> ǵĤ᡼륢ɥ쥹ˤĤƤѸǽ񤭤ޤ",
         "l",
         "A legal address must contain exactly one '\@', and at least one '.' after the \@.");

DefParam("emailsuffix",
         "᡼ºݤȤˡɥ쥹ɲäʸǤ<tt>emailregexp</tt> 桼̾Τߵ褦ѹɤ⡢username\@my.local.hostname ۿͭѤǤ",
         "t",
         "");


DefParam("voteremovedmail",
q{Хɼ줿᡼ʸǤ%to% ϤΥХɼƤ֤ͤޤ%bugid% ϥХֹ֤ޤ%reason% ϡʤΥХ줿ûͳ֤ޤ%votesremoved%, %votesold%  %votesnew% Ϥ줾졢줿ɼȡΥХκɼɼˤʤޤ%votesremovedtext%, %votesoldtext% and %votesnewtext% ϡƱǤʸϤˤʤޤȤ "You had 2 votes on this bug." %count% ϸߴΤ˥ݡȤޤ%<i>ʳ</i>% ϤΥڡ뤽줾֤ޤ},
         "l",
"From: bugzilla-daemon
To: %to%
Subject: [Bug %bugid%] Some or all of your votes have been removed.

bug %bugid% 顢ʤɼĤޤ

%votesoldtext%

%votesnewtext%

Reason: %reason%

%urlbase%show_bug.cgi?id=%bugid%
");
         
DefParam("allowbugdeletion",
         q{ץȤȥݡͥȡСԽڡǡץ(ޤϥݡͥȡС) ȤϢХ٤ƤǤ褦ˤޤϷ빽ݤʤΤǡˤˤɤǲΤİƤƤ},
         "b",
         0);


DefParam("allowemailchange",
         q{桼ʬȤΥ᡼륢ɥ쥹ִĶץڡѹǤ褦ˤʤޤ­ȡѹϤɤΥɥ쥹ˤ᡼뤹뤳Ȥͭˤʤ뤿ᡢˤƤ桼ʤɥ쥹ȤȤΤǤϤޤ},
         "b",
         0);


DefParam("allowuserdeletion",
         q{桼Խڡǡ桼뤳ȤǤ褦ˤʤޤǡ١¾Υơ֥ˤ뤽Υ桼ؤλȤ򤦤ޤõ륳ɤϤޤ󡣤ǤΤǡΤ褦ʺϴǤˤˤɤǲΤİƤƤ},
         "b",
         0);

DefParam("browserbugmessage",
         "Bugzilla ֥饦ͽʤǡäȤθɽΤ˲äơ HTML Ϥޤ",
         "l",
         "this may indicate a bug in your browser.\n");

#
# Parameters to force users to comment their changes for different actions.
DefParam("commentonaccept", 
         "ХȤˡȤʤФʤʤ褦ˤޤ",
         "b", 0 );
DefParam("commentonclearresolution", 
         "Хνˡꥢ줿ȤˡȤʤФʤʤ褦ˤޤ",
         "b", 0 );
DefParam("commentonconfirm", 
         "ǧƤʤХ (UNCONFIRMED) ǧȤˡȤʤФʤʤ褦ˤޤ",
         "b", 0 );
DefParam("commentonresolve", 
         "Х褷ȤˡȤʤФʤʤ褦ˤޤ",
         "b", 0 );
DefParam("commentonreassign", 
         "ƳƤȤˡȤʤФʤʤ褦ˤޤ",
         "b", 0 );
DefParam("commentonreassignbycomponent", 
         "ݡͥȤνôԤ˺ƳƤȤȤʤФʤʤ褦ˤޤ",
         "b", 0 );
DefParam("commentonreopen", 
         "ХƳ (REOPENED) ȤˡȤʤФʤʤ褦ˤޤ",
         "b", 0 );
DefParam("commentonverify", 
         "Х VERIFIED ˤȤȤʤФʤʤ褦ˤޤ",
         "b", 0 );
DefParam("commentonclose", 
         "Х CLOSED ˤȤȤʤФʤʤ褦ˤޤ",
         "b", 0 );
DefParam("commentonduplicate",
         "Х ۤΥХνʣǤȥޡȤˡȤʤФʤʤ褦ˤޤ",
         "b", 0 );
DefParam("supportwatchers",
         "桼¾οͤ᡼ΥԡʬˤƤ館褦ˤޤٲˤäƤͤκԤ䡢γȯԤ˴ϢХ QA 򤷤ƤͤǤ",
         "b", 0 );


DefParam("move-enabled",
         "ˤȡοͤϡ줿ǡ١˥ХܹԤ뤳ȤǤ褦ˤʤޤ",
         "b",
         0);
DefParam("move-button-text",
         "Move ܥɽʸ󡣥ХܹԤ뤳ȤˤʤƤ",
         "t",
         'Move To Bugscape');
DefParam("move-to-url",
         "Bugzilla ХܹԤ뤳ȤĤǡ١ URL Ǥ",
         "t",
         '');
DefParam("move-to-address",
         "ХܹԤȡܹΥǡ١˥᡼ޤΥǡ١ХϿդƤ᡼륢ɥ쥹Ƥ",
         "t",
         'bugzilla-import');
DefParam("moved-from-address",
         "ХܹԤȡܹΥǡ١˥᡼ޤΥ᡼᡼륢ɥ쥹Ƥ顼åϤޤ",
         "t",
         'bugzilla-admin');
DefParam("movers",
         "ХܹԤ뤳ȤǤ ܹԤХ (ܹԤ˼ԤȤ) ƳǤ븢¤ĿͤΥꥹȡ",
         "t",
         '');
DefParam("moved-default-product",
         "ۤΥǡ١餳˰ܹԤХ˳Ƥץȡ",
         "t",
         '');
DefParam("moved-default-component",
         "ۤΥǡ١餳˰ܹԤХ˳Ƥ륳ݡͥȡ",
         "t",
         '');

# The maximum size (in bytes) for patches and non-patch attachments.
# The default limit is 1000KB, which is 24KB less than mysql's default
# maximum packet size (which determines how much data can be sent in a
# single mysql packet and thus how much data can be inserted into the
# database) to provide breathing space for the data in other fields of
# the attachment record as well as any mysql packet overhead (I don't
# know of any, but I suspect there may be some.)

DefParam("maxpatchsize",
         "ѥåκ祵 (Х)Bugzilla ϤΥʾΥѥåϼޤ󡣤ɤʥΥѥåǤդ (WebФ¤˽) ʤ顢ͤ 0 ˤƤ" ,
         "t",
         '1000');

DefParam("maxattachmentsize" , 
         "ѥåʳźեեκ祵 (Х)Bugzilla ϤΥʾźեեϼޤ󡣤ɤʥΥեǤդ (WebФ¤˽) ʤ顢ͤ 0 ˤƤ" , 
         "t" , 
         '1000');

1;
