#!/bin/sh
"exec" "python" "-OO" "$0" "$@" 

import sys, re, string
from a2h import AsciiData, HTMLMaker

class Definition (AsciiData):
    "describe type ascii text."

    def __init__ (self, source):
        self.source = source
        self.border = 1

    def make_desclist (self, source):
        "make dictionary into list for `DL', `DT', `DD' tag."

        descs = []
        buffer = ''

        for line in string.split (source, '\n'):
            line = self.chomp (line)
            spc_m = re.match ('^\s+', line)
            if spc_m == None:
                spcsiz = 0
            else:
                spcsiz = len (spc_m.group ())

            line = string.strip (line)
            if len (line) == 0:
                continue

            if self.border > spcsiz:
                descs.append ({"dt": line})
            else:
                descs.append ({"dd": line})

        return descs

    def __call__ (self):
        return self.make_desclist (self.source)

class HTMLDefinition (HTMLMaker):
    "`DL',`DT',`DD' tag"

    def __init__ (self, source):        
        HTMLMaker.__init__ (self, source)
        parser = Definition (self.source)
        self.source = parser ()

        self.start_dltag = "<dl>"
        self.end_dltag = "</dl>"
        self.dttag_format = "<dt>%s</dt>"
        self.ddtag_format = "<dd>%s</dd>"
    
    def gethtml (self):
        "make and export HTML text."

        # 'DL`,`DT' flags.
        DT = 1
        DD = 2

        lines = []
        bef_type = None
        buffer = ''

        lines.append (self.start_dltag)

        for desc in self.source:
            if desc.has_key ("dt"):

                if bef_type == None:
                    bef_type = DT

                if bef_type == DT:
                    buffer = buffer + desc["dt"]
                elif bef_type == DD:
                    bef_type = DT  
                    lines.append (self.ddtag_format % (buffer))
                    buffer = desc["dt"]

            elif desc.has_key ("dd"):
                if bef_type == None:
                    bef_type = DD

                if bef_type == DD:
                    buffer = buffer + desc["dd"]
                elif bef_type == DT:
                    bef_type = DD
                    lines.append (self.dttag_format % (buffer))
                    buffer = desc["dd"]
                    
        buffer = self.escape (buffer)

        if bef_type == DT:
            lines.append (self.dttag_format % (buffer))
        elif bef_type == DD:
            lines.append (self.ddtag_format % (buffer))

        lines.append (self.end_dltag)
        return string.join (lines, '\n')


if __name__ == '__main__':
    if len (sys.argv) == 2: 
        try:
            istream = open (sys.argv[1])
        except Exception, e:
            print e
            sys.exit (1)
    elif len (sys.argv) == 1: 
        istream = sys.stdin
    else:
        print """\
Usage: %s input-text-file

Report bugs to urago@users.sourceforge.net (enable Japanese)""" % (sys.argv[0])
        sys.exit (1)

    dl = HTMLDefinition (istream.read())
    print dl.gethtml ()
