#!/usr/bin/env python

import sys, re, string, getopt, cgi
from a2h import AsciiHeaderStream, HTMLMaker

class HTMLHeaderMaker (HTMLMaker):
    def __init__ (self, astream):
        self.ascii = astream

        self.level = '1'
        self.htagfmt = "<h%s>%s</h%s>"

    def make_header (self):
        return self.ascii.getheader ()

    def setlevel (self, level):
        self.level = level

    def gethtml (self):
        header = self.make_header ()
        header = cgi.escape (header)
        return self.htagfmt % (self.level , header, self.level)

if __name__ == '__main__':
    try:
        opts, args = getopt.getopt (sys.argv[1:], '123456')
    except Exception, e:
        sys.stderr.write ("%s: invalid option: %s\n" % \
                          (sys.argv[0], str (e)))
        sys.exit (1)

    acceptopt_obj = re.compile ("-([123456])")    

    ahs = AsciiHeaderStream ()
    hth = HTMLHeaderMaker (ahs)

    for opt in opts:
        optm = acceptopt_obj.match (opt[0])
        if optm:
            level = optm.groups (1)[0]
            hth.setlevel (level)
            
    print hth.gethtml ()
