#!/bin/sh
"exec" "python" "$0" "$@" 

import sys, string, cgi
from a2h import AsciiDataStream, HTMLMaker

class AsciiPreformatStream (AsciiDataStream):
    def __init__ (self, stream = sys.stdin):
        AsciiDataStream.__init__ (self, stream)        

        self.prefmt = self.read ()
            
    def getprefmt (self):
        return self.prefmt

class HTMLPreformatMaker (HTMLMaker):
    def __init__ (self, astream):
        self.ascii = astream

        self.pretagfmt = "<pre>%s</pre>"

    def make_prefmt (self):
        return self.ascii.getprefmt ()

    def gethtml (self):
        prefmt = self.make_prefmt ()
        prefmt = cgi.escape (prefmt)
        return self.pretagfmt % (prefmt)

if __name__ == '__main__':
    if len (sys.argv) == 2: 
        try:
            istream = open (sys.argv[1])
        except Exception, e:
            print e
            sys.exit (1)
    elif len (sys.argv) == 1: 
        istream = sys.stdin
    else:
        print """\
Usage: %s input-text-file

Report bugs to urago@users.sourceforge.net (enable Japanese)""" % (sys.argv[0])
        sys.exit (1)

    apres = AsciiPreformatStream (istream)
    htpre = HTMLPreformatMaker (apres)
    print htpre.gethtml ()
