/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.CandleStickLowAvgLine;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="CandleStickLowAvgLine")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"closeRatio"})
public class CandleStickLowAvgLineStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final CandleStickLowAvgLine m_candleStickLowAvgLine;

    public CandleStickLowAvgLineStream(String p_label, GeneList p_geneList, String p_closeRatioLabel) throws GeneListException {
        super(p_label);
        Gene closeRatioGene = p_geneList.getGene(p_closeRatioLabel);
        double closeRatio = closeRatioGene.getDoubleValue();
        this.m_candleStickLowAvgLine = new CandleStickLowAvgLine(closeRatio);
    }

    public void enter(CandleStickList p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndex(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (p_indexObjectList == null) {
            throw new IndexStreamException("Null Error");
        }
        if (!(p_indexObjectList instanceof CandleStickList)) {
            throw new IndexStreamException("Instance Error");
        }
        if (p_indexObjectList.size() <= 0) {
            return;
        }
        int prevSize = this.m_candleStickLowAvgLine.size();
        this.m_candleStickLowAvgLine.addPoint((CandleStick)p_indexObjectList.getLast());
        if (this.m_candleStickLowAvgLine.size() > prevSize) {
            this.notifyIndexNext(this.m_candleStickLowAvgLine);
        }
    }

    public CandleStickLowAvgLine getValues() {
        return this.m_candleStickLowAvgLine;
    }
}

