/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.EnabledDefaultSignal;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.JudgmentResult;
import jp.robotbrain.signal.NmSignal;
import jp.robotbrain.signal.SignalStream;
import jp.robotbrain.signal.TypeSignalStream;

@TypeSignalStream
@EnabledDefaultSignal
@GeneDefaultLabelList(values={"border"})
@InputComponentList(values={"@IndexLine"})
public class ExceedBorderDefaultSignal
extends SignalStream {
    private final double m_border;

    public ExceedBorderDefaultSignal(String p_label, int p_priority, GeneList p_geneList, String p_borderLabel) throws GeneListException {
        super(p_label, p_priority);
        this.m_border = p_geneList.getGene(p_borderLabel).getDoubleValue();
        this.getPortList().add("@IndexLine");
    }

    @Override
    public JudgmentResult getJudgmentResult() throws IndexStreamException {
        IndexStreamPort p = this.getPortList().get("@IndexLine");
        if (p == null) {
            throw new IndexStreamException("Null Error");
        }
        if (p.getObjectList() == null) {
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        if (!(p.getObjectList() instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        IndexLine line = (IndexLine)p.getObjectList();
        if (line.size() < 1) {
            this.setDetails(NmSignal.NOSIGNAL.toString());
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        NmSignal returnValue = NmSignal.NOSIGNAL;
        if (((IndexPoint)line.getLast()).getValue() > this.m_border) {
            returnValue = this.getDefaultSignal();
        }
        this.setDetails("[" + this.getLabel() + "]" + returnValue.toString());
        return new JudgmentResult(((IndexPoint)line.getLast()).getTag(), returnValue);
    }
}

