/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.JudgmentResult;
import jp.robotbrain.signal.NmSignal;
import jp.robotbrain.signal.SignalStream;
import jp.robotbrain.signal.TypeSignalStream;

@TypeSignalStream
@InputComponentList(values={"@IndexLine"})
public class RiseNeutralFallNoSignalSignal
extends SignalStream {
    private NmSignal m_prevSignal = NmSignal.NOSIGNAL;

    public RiseNeutralFallNoSignalSignal(String p_label, int p_priority) {
        super(p_label, p_priority);
        this.getPortList().add("@IndexLine");
    }

    @Override
    public JudgmentResult getJudgmentResult() throws IndexStreamException {
        IndexStreamPort p = this.getPortList().get("@IndexLine");
        if (p == null) {
            throw new IndexStreamException("Port Null Error");
        }
        if (p.getObjectList() == null) {
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        if (!(p.getObjectList() instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        IndexLine line = (IndexLine)p.getObjectList();
        if (line.size() < 2) {
            this.setDetails(NmSignal.NOSIGNAL.toString());
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        NmSignal returnValue = NmSignal.NOSIGNAL;
        if (((IndexPoint)line.getLast()).getValue() > ((IndexPoint)line.getPrev(1)).getValue()) {
            this.m_prevSignal = returnValue = NmSignal.NEUTRAL;
        } else if (((IndexPoint)line.getLast()).getValue() < ((IndexPoint)line.getPrev(1)).getValue()) {
            this.m_prevSignal = returnValue = NmSignal.NOSIGNAL;
        } else {
            returnValue = this.m_prevSignal;
        }
        this.setDetails("[" + this.getLabel() + "]" + returnValue.toString());
        return new JudgmentResult(((IndexPoint)line.getLast()).getTag(), returnValue);
    }
}

