/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.ChannelHighLine;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="ChannelHighLine")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"ccount"})
public class ChannelHighLineStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final ChannelHighLine m_channelHighLine;
    private int m_cost;

    public ChannelHighLineStream(String p_label, GeneList p_geneList, String p_ccountLabel) throws GeneListException {
        super(p_label);
        Gene ccountGene = p_geneList.getGene(p_ccountLabel);
        this.m_cost = ccountGene.getIntValue();
        this.m_channelHighLine = new ChannelHighLine(this.m_cost);
    }

    public void enter(CandleStickList p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndexSub(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (!(p_indexObjectList instanceof CandleStickList)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_channelHighLine.addPoint((CandleStickList)p_indexObjectList);
        this.notifyIndexNext(this.m_channelHighLine);
    }

    public ChannelHighLine getValues() {
        return this.m_channelHighLine;
    }

    @Override
    public int getCost() {
        return this.m_cost;
    }

    @Override
    public void economizeCapacity() {
        this.m_channelHighLine.setCapacity(this.getDestinationMaxCost());
    }
}

