/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.io.PrintStream;
import java.io.Serializable;
import jp.robotbrain.framework.Current;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.Tag;

public class CandleStick
extends IndexPoint
implements Current,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private double m_open;
    private double m_high;
    private double m_low;
    private double m_close;

    public CandleStick() {
    }

    public CandleStick(Tag p_tag, double p_open, double p_high, double p_low, double p_close) {
        super(p_tag, p_close);
        this.m_open = p_open;
        this.m_high = p_high;
        this.m_low = p_low;
        this.m_close = p_close;
    }

    @Override
    public CandleStick clone() {
        CandleStick returnValue = new CandleStick(this.getTag(), this.m_open, this.m_high, this.m_low, this.m_close);
        return returnValue;
    }

    public double getOpen() {
        return this.m_open;
    }

    public void setOpen(double p_open) {
        this.m_open = p_open;
    }

    public double getHigh() {
        return this.m_high;
    }

    public void setHigh(double p_high) {
        this.m_high = p_high;
    }

    public double getLow() {
        return this.m_low;
    }

    public void setLow(double p_low) {
        this.m_low = p_low;
    }

    public double getClose() {
        return this.m_close;
    }

    public void setClose(double p_close) {
        this.m_close = p_close;
        this.setValue(this.m_close);
    }

    @Override
    public boolean isSet() {
        return true;
    }

    public double getAvg() {
        return (this.getHigh() + this.getLow() + this.getClose()) / 3.0;
    }

    @Override
    public void printHeader(PrintStream p_out) {
        p_out.println("Tag,Open,High,Low,Close,Avg");
    }

    @Override
    public void print(PrintStream p_out) {
        p_out.println("'" + this.getTag().getValue() + "'," + this.getOpen() + "," + this.getHigh() + "," + this.getLow() + "," + this.getClose() + "," + this.getAvg());
    }

    @Override
    public final String toXml() {
        StringBuilder returnValue = new StringBuilder();
        returnValue.append("<candlestick tag=\"");
        returnValue.append(this.getTag().getValue());
        returnValue.append("\">");
        returnValue.append("<open>");
        returnValue.append(this.getOpen());
        returnValue.append("</open>");
        returnValue.append("<high>");
        returnValue.append(this.getHigh());
        returnValue.append("</high>");
        returnValue.append("<low>");
        returnValue.append(this.getLow());
        returnValue.append("</low>");
        returnValue.append("<close>");
        returnValue.append(this.getClose());
        returnValue.append("</close>");
        returnValue.append("<avg>");
        returnValue.append(this.getAvg());
        returnValue.append("</avg>");
        returnValue.append("</candlestick>");
        return returnValue.toString();
    }
}

