/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexLineStream;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.StdevLine;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="StdevLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"pcount"})
public class StdevLineStream
extends IndexLineStream {
    private static final long serialVersionUID = 1L;
    private final StdevLine m_stdevLine;
    private int m_cost;

    public StdevLineStream(String p_label, GeneList p_geneList, String p_pcountLabel) throws GeneListException {
        super(p_label);
        Gene pcountGene = p_geneList.getGene(p_pcountLabel);
        this.m_cost = pcountGene.getIntValue();
        this.m_stdevLine = new StdevLine(this.m_cost);
    }

    public void enter(IndexLine p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndexSub(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (!(p_indexObjectList instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_stdevLine.addPoint((IndexLine)p_indexObjectList);
        this.notifyIndexNext(this.m_stdevLine);
    }

    @Override
    public StdevLine getValues() {
        return this.m_stdevLine;
    }

    @Override
    public int getCost() {
        return this.m_cost;
    }

    @Override
    public void economizeCapacity() {
        this.m_stdevLine.setCapacity(this.getDestinationMaxCost());
    }
}

