/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.Stochastics;

public class StochasticsList
extends IndexObjectList<Stochastics> {
    private static final long serialVersionUID = 1L;
    private final int m_ccountRange;
    private final int m_pcountD;

    public StochasticsList(int p_ccountRange, int p_pcountD) {
        this.m_ccountRange = p_ccountRange;
        this.m_pcountD = p_pcountD;
    }

    public void addObject(CandleStickList p_src) {
        if (p_src == null) {
            return;
        }
        if (p_src.size() < this.m_ccountRange) {
            return;
        }
        CandleStickList tail = new CandleStickList(p_src.getTailList(this.m_ccountRange));
        if (tail.getLast() == null) {
            return;
        }
        CandleStick c = (CandleStick)p_src.getLast();
        Stochastics stochastics = new Stochastics(c.getTag());
        stochastics.setCurrentRange(this.getCurrentRange(tail));
        stochastics.setMaxRange(this.getMaxRange(tail));
        stochastics.setK(100.0 * stochastics.getCurrentRange() / stochastics.getMaxRange());
        this.add(stochastics);
        if (this.size() >= this.m_pcountD) {
            double sumCurrentRange = 0.0;
            double sumMaxRange = 0.0;
            IndexObjectList ds = this.getTailList(this.m_pcountD);
            for (Stochastics p : ds.getObjectList()) {
                sumCurrentRange += p.getCurrentRange();
                sumMaxRange += p.getMaxRange();
            }
            stochastics.setD(100.0 * sumCurrentRange / sumMaxRange);
        } else {
            stochastics.setD(0.0);
        }
        if (this.size() >= this.m_pcountD) {
            double sumD = 0.0;
            IndexObjectList ds = this.getTailList(this.m_pcountD);
            for (Stochastics p : ds.getObjectList()) {
                sumD += p.getD();
            }
            stochastics.setSlowD(sumD / (double)this.m_pcountD);
        } else {
            stochastics.setSlowD(0.0);
        }
    }

    private double getCurrentRange(CandleStickList p_src) {
        CandleStick c = (CandleStick)p_src.getLast();
        return c.getClose() - p_src.getMin();
    }

    private double getMaxRange(CandleStickList src) {
        return src.getMax() - src.getMin();
    }
}

