/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.graph;

import java.awt.Color;
import jp.robotbrain.graph.GraphException;
import jp.robotbrain.graph.GraphPanel;
import jp.robotbrain.graph.GraphRuler;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.NmViewType;
import jp.robotbrain.signal.Tag;

public class GraphLayer {
    private final String m_name;
    private final GraphRuler m_ruler;
    private final int m_overLapNo;
    private String m_title;
    private int m_indexScale;
    private IndexObjectList<?> m_srcList;
    private double m_max;
    private double m_min;
    private int m_heightRatio;
    private Tag m_prevTag;
    private Color m_foreColor;
    private boolean m_statusColor;
    private int m_top;
    private int m_titleBarTopOffset;
    private int m_titleBarHeight;
    private int m_indexTopOffset;
    private boolean m_syncRuler;

    protected GraphLayer(GraphPanel p_parent, String p_name, boolean p_isMain, IndexObjectList<?> p_srcLine, int p_overLapNo) throws GraphException {
        this.m_name = p_name;
        this.m_heightRatio = 100;
        this.m_overLapNo = p_overLapNo;
        this.m_titleBarTopOffset = 5;
        this.m_foreColor = Color.BLACK;
        this.m_title = "";
        this.m_syncRuler = true;
        this.m_ruler = new GraphRuler();
        if (p_srcLine.size() < 2) {
            throw new GraphException("Few SrcLine Values");
        }
        if (p_isMain) {
            this.initMainLayer(p_parent, p_srcLine);
        } else {
            this.initSubLayer(p_parent, p_srcLine);
        }
    }

    private void initMainLayer(GraphPanel p_parent, IndexObjectList<?> p_srcLine) {
        int viewPointCount = p_parent.getWidthPointCount();
        if (viewPointCount > p_srcLine.size()) {
            viewPointCount = p_srcLine.size();
        }
        if (p_srcLine instanceof CandleStickList) {
            CandleStickList src = (CandleStickList)p_srcLine;
            CandleStickList srcTail = src.getTailList(viewPointCount);
            if (p_srcLine.getViewType() == NmViewType.INDEXLINE_PERCENTAGE) {
                this.m_max = 100.0;
                this.m_min = 0.0;
            } else {
                this.m_max = srcTail.getMax();
                this.m_min = srcTail.getMin();
            }
            this.m_srcList = srcTail;
        } else if (p_srcLine instanceof IndexLine) {
            IndexLine src = (IndexLine)p_srcLine;
            IndexLine srcTail = src.getTailLine(viewPointCount);
            if (p_srcLine.getViewType() == NmViewType.INDEXLINE_PERCENTAGE) {
                this.m_max = 100.0;
                this.m_min = 0.0;
            } else {
                this.m_max = srcTail.getMax().getValue();
                this.m_min = srcTail.getMin().getValue();
            }
            this.m_srcList = srcTail;
        } else {
            this.m_max = 0.0;
            this.m_min = 0.0;
            this.m_srcList = p_srcLine;
        }
    }

    private void initSubLayer(GraphPanel p_parent, IndexObjectList<?> p_srcLine) throws GraphException {
        if (p_parent.getMainLayer() == null) {
            throw new GraphException("Not Found MainLayer");
        }
        if (p_parent.getMainLayer().getSrcList().size() <= 0) {
            throw new GraphException("Not Found MainLayer");
        }
        Object idx = p_parent.getMainLayer().getSrcList().get(0);
        if (p_srcLine instanceof CandleStickList) {
            CandleStickList src = (CandleStickList)p_srcLine;
            CandleStickList srcTail = src.getTailList(((IndexObject)idx).getTag());
            if (p_srcLine.getViewType() == NmViewType.INDEXLINE_PERCENTAGE) {
                this.m_max = 100.0;
                this.m_min = 0.0;
            } else {
                this.m_max = srcTail.getMax();
                this.m_min = srcTail.getMin();
            }
            this.m_srcList = srcTail;
        } else if (p_srcLine instanceof IndexLine) {
            IndexLine src = (IndexLine)p_srcLine;
            IndexLine srcTail = src.getTailLine(((IndexObject)idx).getTag());
            if (p_srcLine.getViewType() == NmViewType.INDEXLINE_PERCENTAGE) {
                this.m_max = 100.0;
                this.m_min = 0.0;
            } else {
                this.m_max = srcTail.getMax().getValue();
                this.m_min = srcTail.getMin().getValue();
            }
            this.m_srcList = srcTail;
        } else {
            this.m_max = 0.0;
            this.m_min = 0.0;
            this.m_srcList = p_srcLine;
        }
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public boolean equals(Object p_other) {
        if (!(p_other instanceof GraphLayer)) {
            return false;
        }
        GraphLayer other = (GraphLayer)p_other;
        return this.m_name.equals(other.getName());
    }

    public String getName() {
        return this.m_name;
    }

    public double getMax() {
        return this.m_max;
    }

    public void setMax(double p_max) {
        this.m_max = p_max;
    }

    public double getMin() {
        return this.m_min;
    }

    public void setMin(double p_min) {
        this.m_min = p_min;
    }

    public IndexObjectList<?> getSrcList() {
        return this.m_srcList;
    }

    private double getRatio(int p_panelHeight) {
        double indexViewHeight = p_panelHeight * this.m_heightRatio / 100 - (this.m_titleBarTopOffset + this.m_titleBarHeight + this.m_indexTopOffset);
        double srcLineRange = this.m_max - this.m_min;
        return indexViewHeight / srcLineRange;
    }

    public void setTop(int p_top) {
        this.m_top = p_top;
    }

    public int getTop() {
        return this.m_top;
    }

    public int getTitleBarTop() {
        return this.m_top + this.m_titleBarTopOffset;
    }

    public int getIndexTop() {
        return this.getTitleBarTop() + this.m_titleBarHeight + this.m_indexTopOffset;
    }

    public void setPrevTag(Tag p_prevTag) {
        this.m_prevTag = p_prevTag;
    }

    public Tag getPrevTag() {
        return this.m_prevTag;
    }

    protected int calcY(double p_value, int p_panelHeight) {
        return (int)((this.getMax() - p_value) * this.getRatio(p_panelHeight)) + this.getIndexTop();
    }

    protected int calcYDistance(double p_distance, int p_panelHeight) {
        return (int)(p_distance * this.getRatio(p_panelHeight));
    }

    public void setIndexScale(int p_indexScale) {
        this.m_indexScale = p_indexScale;
    }

    public int getIndexScale() {
        return this.m_indexScale;
    }

    public int getOverLapNo() {
        return this.m_overLapNo;
    }

    public int getTitleBarHeight() {
        return this.m_titleBarHeight;
    }

    public void setTitleBarHeight(int p_titleBarHeight) {
        this.m_titleBarHeight = p_titleBarHeight;
    }

    public int getTitleBarTopOffset() {
        return this.m_titleBarTopOffset;
    }

    public void setTitleBarTopOffset(int p_titleBarTopOffset) {
        this.m_titleBarTopOffset = p_titleBarTopOffset;
    }

    public int getIndexTopOffset() {
        return this.m_indexTopOffset;
    }

    public void setIndexTopOffset(int p_indexTopOffset) {
        this.m_indexTopOffset = p_indexTopOffset;
    }

    public Color getForeColor() {
        return this.m_foreColor;
    }

    public void setForeColor(Color p_foreColor) {
        this.m_foreColor = p_foreColor;
    }

    public boolean isStatusColor() {
        return this.m_statusColor;
    }

    public void setStatusColor(boolean p_statusColor) {
        this.m_statusColor = p_statusColor;
    }

    public int getHeightRatio() {
        return this.m_heightRatio;
    }

    public void setHeightRatio(int p_heightRatio) {
        this.m_heightRatio = p_heightRatio;
    }

    public GraphRuler getRuler() {
        return this.m_ruler;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String p_title) {
        this.m_title = p_title;
    }

    public boolean isSyncRuler() {
        return this.m_syncRuler;
    }

    public void setSyncRuler(boolean p_syncRuler) {
        this.m_syncRuler = p_syncRuler;
    }
}

