/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.util.ArrayList;
import jp.robotbrain.signal.CalcException;
import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexPoint;

public class UtilSignal {
    private UtilSignal() {
    }

    public static double calcAvg(IndexLine p_src) {
        double sum = 0.0;
        int i = 0;
        while (i < p_src.size()) {
            sum += ((IndexPoint)p_src.get(i)).getValue();
            ++i;
        }
        if (p_src.size() == 0) {
            return 0.0;
        }
        return sum / (double)p_src.size();
    }

    public static double calcStdev(IndexLine p_src) {
        double sum = 0.0;
        double avg = UtilSignal.calcAvg(p_src);
        int i = 0;
        while (i < p_src.size()) {
            double v = ((IndexPoint)p_src.get(i)).getValue();
            sum += (v - avg) * (v - avg);
            ++i;
        }
        if (p_src.size() == 0) {
            return 0.0;
        }
        return Math.sqrt(sum / (double)p_src.size());
    }

    public static double calcTrueRange(CandleStick p_prevCandleStick, CandleStick p_currentCandleStick) {
        double trA = p_currentCandleStick.getHigh() - p_currentCandleStick.getLow();
        double trB = p_currentCandleStick.getHigh() - p_prevCandleStick.getClose();
        double trC = p_prevCandleStick.getClose() - p_currentCandleStick.getLow();
        double trMax = 0.0;
        trMax = trA > trB ? (trA < trC ? trC : trA) : (trB < trC ? trC : trB);
        return trMax;
    }

    public static double calcCorrelationCoefficient(IndexLine p_src1, IndexLine p_src2) throws CalcException {
        ArrayList<Double> valueList1 = new ArrayList<Double>();
        ArrayList<Double> valueList2 = new ArrayList<Double>();
        int j = 0;
        int i = 0;
        block0: while (i < p_src1.size()) {
            block6: {
                IndexPoint p1 = (IndexPoint)p_src1.get(i);
                if (j > p_src2.size() - 1) break;
                IndexPoint p2 = (IndexPoint)p_src2.get(j);
                while (!p1.getTag().equals(p2.getTag())) {
                    IndexPoint nxp1;
                    if (p_src1.size() <= i + 1 || (nxp1 = (IndexPoint)p_src1.get(i + 1)).getTag().getCalendar().compareTo(p2.getTag().getCalendar()) > 0) {
                        if (++j > p_src2.size() - 1) break block0;
                        p2 = (IndexPoint)p_src2.get(j);
                        continue;
                    }
                    break block6;
                }
                valueList1.add(p1.getValue());
                valueList2.add(p2.getValue());
            }
            ++i;
        }
        if (valueList1.isEmpty() || valueList2.isEmpty()) {
            throw new CalcException("src line is empty");
        }
        int n = valueList1.size();
        double v1t = 0.0;
        double v2t = 0.0;
        double v1v1t = 0.0;
        double v2v2t = 0.0;
        double v1v2t = 0.0;
        int i2 = 0;
        while (i2 < n) {
            v1t += ((Double)valueList1.get(i2)).doubleValue();
            v2t += ((Double)valueList2.get(i2)).doubleValue();
            v1v1t += (Double)valueList1.get(i2) * (Double)valueList1.get(i2);
            v2v2t += (Double)valueList2.get(i2) * (Double)valueList2.get(i2);
            v1v2t += (Double)valueList1.get(i2) * (Double)valueList2.get(i2);
            ++i2;
        }
        double avg1 = v1t / (double)n;
        double avg2 = v2t / (double)n;
        double sd1 = v1v1t / (double)n - avg1 * avg1;
        double sd2 = v2v2t / (double)n - avg2 * avg2;
        double sq1 = Math.sqrt(sd1);
        double sq2 = Math.sqrt(sd2);
        if (sq1 == 0.0 || sq2 == 0.0) {
            throw new CalcException("div zero");
        }
        double returnValue = (v1v2t / (double)n - avg1 * avg2) / (sq1 * sq2);
        return returnValue;
    }
}

