/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.framework;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import jp.robotbrain.common.StringComparator;
import jp.robotbrain.framework.HistoricalDataException;
import jp.robotbrain.framework.Pointer;

public class HistoricalTradingDateList {
    private Pointer m_pointer;
    private ArrayList<String> m_tradingDateList;
    private static HashMap<String, HistoricalTradingDateList> m_cacheTable = new HashMap();

    private HistoricalTradingDateList() {
    }

    public static synchronized HistoricalTradingDateList create(String p_historicalDataFolderPath) throws HistoricalDataException {
        return HistoricalTradingDateList.create(p_historicalDataFolderPath, false);
    }

    public static synchronized HistoricalTradingDateList create(String p_historicalDataFolderPath, boolean p_reload) throws HistoricalDataException {
        HistoricalTradingDateList cache;
        HistoricalTradingDateList returnValue = null;
        if (!p_reload && (cache = m_cacheTable.get(p_historicalDataFolderPath.toUpperCase())) != null) {
            returnValue = new HistoricalTradingDateList();
            returnValue.m_pointer = new Pointer();
            returnValue.m_tradingDateList = (ArrayList)cache.m_tradingDateList.clone();
            return returnValue;
        }
        returnValue = new HistoricalTradingDateList();
        returnValue.m_pointer = new Pointer();
        returnValue.m_tradingDateList = new ArrayList();
        if (p_historicalDataFolderPath == null || p_historicalDataFolderPath.equals("")) {
            String msg = "HistoricalData Path Error: " + p_historicalDataFolderPath;
            throw new HistoricalDataException(msg);
        }
        File f = new File(p_historicalDataFolderPath);
        File[] flist = f.listFiles();
        if (flist == null) {
            String msg = "HistoricalData Listing Error: " + p_historicalDataFolderPath;
            throw new HistoricalDataException(msg);
        }
        int i = 0;
        while (i < flist.length) {
            returnValue.m_tradingDateList.add(flist[i].getName());
            ++i;
        }
        Collections.sort(returnValue.m_tradingDateList, new StringComparator(false));
        m_cacheTable.put(p_historicalDataFolderPath.toUpperCase(), returnValue);
        return returnValue;
    }

    public ArrayList<String> getPastList(String p_tradingDate, int p_pastDays) throws HistoricalDataException {
        ArrayList<String> returnValue = new ArrayList<String>();
        if (this.m_tradingDateList.size() <= 0) {
            return returnValue;
        }
        int tradingDatePoint = this.m_tradingDateList.indexOf(p_tradingDate);
        if (tradingDatePoint < 0) {
            String lastDate = this.m_tradingDateList.get(this.m_tradingDateList.size() - 1);
            if (Integer.parseInt(lastDate) < Integer.parseInt(p_tradingDate)) {
                tradingDatePoint = this.m_tradingDateList.size();
            } else {
                String msg = "NotFound HistoricalData lastDate:" + lastDate + " tradingDate:" + p_tradingDate;
                throw new HistoricalDataException(msg);
            }
        }
        int i = p_pastDays;
        while (i >= 1) {
            if (tradingDatePoint - i >= 0) {
                String pastDate = this.m_tradingDateList.get(tradingDatePoint - i);
                returnValue.add(pastDate);
            }
            --i;
        }
        return returnValue;
    }

    public String moveFirst() {
        if (this.m_tradingDateList.size() <= 0) {
            return "";
        }
        this.m_pointer.moveFirst();
        return this.m_tradingDateList.get(0);
    }

    public String moveLast() {
        if (this.m_tradingDateList.size() < 1) {
            return "";
        }
        int lastPointer = this.m_tradingDateList.size() - 1;
        this.m_pointer.move(lastPointer);
        return this.m_tradingDateList.get(lastPointer);
    }

    public String moveNext() {
        if (this.m_tradingDateList.size() <= this.m_pointer.getValue() + 1) {
            return "";
        }
        this.m_pointer.moveNext();
        return this.m_tradingDateList.get(this.m_pointer.getValue());
    }

    public String movePrev() {
        if (this.m_pointer.getValue() - 1 < 0) {
            return "";
        }
        this.m_pointer.movePrev();
        return this.m_tradingDateList.get(this.m_pointer.getValue());
    }

    public String movePrev(int p_prevDays) {
        String returnValue = "";
        int i = 0;
        while (i < p_prevDays) {
            returnValue = this.movePrev();
            if (returnValue.equals("")) {
                return this.moveFirst();
            }
            ++i;
        }
        return returnValue;
    }

    public String move(String p_tradingDate) {
        int i = this.m_tradingDateList.indexOf(p_tradingDate);
        if (i < 0) {
            return "";
        }
        this.m_pointer.move(i);
        return this.m_tradingDateList.get(this.m_pointer.getValue());
    }

    public ArrayList<String> getValues() {
        return this.m_tradingDateList;
    }

    public String getCurrentTradingDate() {
        return this.m_tradingDateList.get(this.m_pointer.getValue());
    }
}

