/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexLineStream;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.MultiplicationLine;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="MultiplicationLine")
@InputComponentList(values={"A@IndexLine", "B@IndexLine"})
public class MultiplicationLineStream
extends IndexLineStream {
    private static final long serialVersionUID = 1L;
    private final MultiplicationLine m_multiplicationLine = new MultiplicationLine();

    public MultiplicationLineStream(String p_label) {
        super(p_label);
        this.getPortList().add("A@IndexLine", 1);
        this.getPortList().add("B@IndexLine", 1);
    }

    @Override
    public boolean notifyIndexSub() throws IndexStreamException {
        IndexStreamPort portA = this.getPortList().get("A@IndexLine");
        IndexStreamPort portB = this.getPortList().get("B@IndexLine");
        if (!(portA.getIndexStream().getValues() instanceof IndexLine)) {
            throw new IndexStreamException("A Instance Error");
        }
        if (!(portB.getIndexStream().getValues() instanceof IndexLine)) {
            throw new IndexStreamException("B Instance Error");
        }
        if (!((IndexObject)portA.getIndexStream().getValues().getLast()).getTag().equals(((IndexObject)portB.getIndexStream().getValues().getLast()).getTag())) {
            return false;
        }
        this.m_multiplicationLine.addPoint((IndexLine)portA.getIndexStream().getValues(), (IndexLine)portB.getIndexStream().getValues());
        return this.notifyIndexNext();
    }

    @Override
    public MultiplicationLine getValues() {
        return this.m_multiplicationLine;
    }

    public MultiplicationLine getViewValues() {
        return this.m_multiplicationLine;
    }

    @Override
    public void economizeMemory() {
        this.m_multiplicationLine.setCapacity(this.getDestinationMaxCost());
    }

    @Override
    public void economizeMemory(int p_capacity) {
        int capacity = Math.max(p_capacity, this.getDestinationMaxCost());
        this.m_multiplicationLine.setCapacity(capacity);
    }
}

