/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.EntryPoint;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexLineStream;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.SimpleLine;
import jp.robotbrain.signal.TypeIndexStream;

@EntryPoint
@TypeIndexStream(value="SimpleLine")
@InputComponentList(values={"@IndexLine"})
public class SimpleLineStream
extends IndexLineStream {
    private static final long serialVersionUID = 1L;
    private final SimpleLine m_simpleLine = new SimpleLine();
    private final SimpleLine m_viewSimpleLine = new SimpleLine();

    public SimpleLineStream(String p_label) {
        super(p_label);
        this.getPortList().add("@IndexLine", 1);
    }

    public boolean enter(IndexPoint p_src) throws IndexStreamException {
        if (p_src == null) {
            throw new IndexStreamException("Null Error");
        }
        this.m_simpleLine.addPoint(p_src);
        if (this.m_simpleLine.getCapacity() != Integer.MAX_VALUE) {
            this.m_viewSimpleLine.addPoint(p_src);
        }
        return this.notifyIndexNext();
    }

    @Override
    public boolean notifyIndexSub() throws IndexStreamException {
        IndexStreamPort port = this.getPortList().get("@IndexLine");
        if (!(port.getIndexStream().getValues() instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        IndexLine il = (IndexLine)port.getIndexStream().getValues();
        this.m_simpleLine.addPoint((IndexPoint)il.getLast());
        if (this.m_simpleLine.getCapacity() != Integer.MAX_VALUE) {
            this.m_viewSimpleLine.addPoint((IndexPoint)il.getLast());
        }
        return this.notifyIndexNext();
    }

    @Override
    public SimpleLine getValues() {
        return this.m_simpleLine;
    }

    public SimpleLine getViewValues() {
        if (this.m_simpleLine.getCapacity() == Integer.MAX_VALUE) {
            return this.m_simpleLine;
        }
        return this.m_viewSimpleLine;
    }

    @Override
    public void economizeMemory() {
        this.m_simpleLine.setCapacity(this.getDestinationMaxCost());
    }

    @Override
    public void economizeMemory(int p_capacity) {
        int capacity = Math.max(p_capacity, this.getDestinationMaxCost());
        this.m_simpleLine.setCapacity(capacity);
    }
}

