# 
# test_link_link.rb
# 
# Author : Mitsuyoshi Yoshida
# This program is freely distributable under the terms of an MIT-style license.
# 

require 'i18n'


class TestLinkKeyInfo
  attr_accessor :linkstr, :idno, :isusearg

  def initialize(linkstr, idno=1)
    @linkstr = linkstr
    @idno = idno
  end

end


class TestLinkLink

  private
  
  KeyTable = {
    'case' => TestLinkKeyInfo.new('testcases/archiveData.php?targetTestCase=%s&edit=testcase'),
    'suite' => TestLinkKeyInfo.new('testcases/archiveData.php?print_scope=test_specification&edit=testsuite&level=testsuite&id=%s'),
    'project' => TestLinkKeyInfo.new('project/projectEdit.php?doAction=edit&tprojectID=%s'),
    'plan' => TestLinkKeyInfo.new('plan/planEdit.php?do_action=edit&tplan_id=%s'),
    'milestone' => TestLinkKeyInfo.new('plan/planMilestonesEdit.php?doAction=edit&id=%s'),
    'build' => TestLinkKeyInfo.new('plan/buildEdit.php?do_action=edit&build_id=%s'),
    'cfield' => TestLinkKeyInfo.new('cfields/cfieldsEdit.php?do_action=edit&cfield_id=%s'),
    'keyword' => TestLinkKeyInfo.new('keywords/keywordsEdit.php?doAction=edit&id=%s'),
    'user' => TestLinkKeyInfo.new('usermanagement/usersEdit.php?doAction=edit&user_id=%s'),
    'planreport' => TestLinkKeyInfo.new('results/printDocument.php?level=testsuite&id=%s&type=testplan&docTestPlanId=%s&format=0', 2),
    'report' => TestLinkKeyInfo.new('results/printDocument.php?level=testsuite&id=%s&type=testreport&docTestPlanId=%s&format=0', 2),
    'metrics' => TestLinkKeyInfo.new('results/resultsGeneral.php?format=0&tplan_id=%s'),
    'result' => TestLinkKeyInfo.new('results/resultsTC.php?format=0&tplan_id=%s'),
    'graph' => TestLinkKeyInfo.new('results/charts.php?format=0&tplan_id=%s')
  }
  DefaultArgs = {
    "planreport" => ['summary'],
    "report" => ['summary', 'passfail']
  }

  public
  
  def initialize(*args)
    @ids = []
    @key = nil
    @restargs = []
    @keyinfo = nil
    args.each {|arg|
      val = nil
      if arg
        val = arg.strip
        val = nil 	if val.empty?
      end
      if (!@key)
        @key = val
        raise I18n.t('error.no_key')	unless val
        @keyinfo = KeyTable[val]
        unless @keyinfo
          raise I18n.t('error.invalid_key')
        end
      elsif (@ids.size < @keyinfo.idno)
        raise I18n.t('error.no_id')	unless val
        @ids << val
      else
        @restargs << val	if val
      end
    }
  end

  def link
    idstr = @ids.join('-')
    viewstr = "TestLink:#{@key}##{idstr}"
    if (0 < @restargs.size)
      viewstr += "(#{@restargs.join(', ')})"
    end
    linkstr = sprintf(@keyinfo.linkstr, *@ids)
    if (@key == 'report' or @key == 'planreport')
      args = (0 < @restargs.size) ? @restargs : DefaultArgs[@key]
      linkstr += '&' + args.map{|e| e + '=y'}.join('&')
    elsif (@key = 'result' and (0 < @restargs.size))
      linkstr = sprintf('results/resultsByStatus.php?format=0&tplan_id=%s', @ids[0])
      linkstr += '&type=' + @restargs[0]
    end
    linkstr = "lib/" + linkstr
    linkstr = File.join(Setting.plugin_redmine_testlinklink["testlink_address"], linkstr)
    "<a class='testlinklink' href='#{linkstr}' target='_blank'>#{viewstr}</a>"
  end
  

end
