
require 'redmine'


Redmine::Plugin.register :redmine_testlinklink do
  name 'Testlink Link plugin'
  author 'Mitsuyoshi Yoshida'
  description 'Links the test case, the project and so on from Redmine to TestLink.'
  version '0.4.0'

  settings :default => {
    'testlink_address' => 'http://localhost/testlink',
    'testlink_version' => '1.8',
  }, :partial => 'settings/testlinklink_settings'
end


Redmine::WikiFormatting::Macros.register do
  desc "TestLink link macro"
  macro :testlink do |obj, args|
    tl = TestLinkLink.new(*args)
    tl.link
  end
end

Redmine::WikiFormatting::Macros.register do
  desc "TestLink TestCase link macro"
  macro :testcase do |obj, args|
    tl = TestLinkLink.new('case', *args)
    tl.link
  end
end

Redmine::WikiFormatting::Macros.register do
  desc "TestLink TestReport link macro"
  macro :testreport do |obj, args|
    tl = TestLinkLink.new('report', *args)
    tl.link
  end
end


Redmine::WikiFormatting::Macros.register do
  desc "TestLink TestFile link macro"
  macro :testfile do |obj, args|
    fmtname = args.shift
    tl = TestLinkLink.new(*args)
    tl.formatname = fmtname
    tl.link
  end
end
