
package jp.sourceforge.torkenizer.test;

import java.util.regex.Pattern;

import jp.sourceforge.tokenizer.Token;
import jp.sourceforge.tokenizer.TokenInfo;

/**
 * 左括弧"("のトークン情報です。
 * 
 * @author uguu@users.sourceforge.jp
 */
public class LeftBracketTokenInfo implements TokenInfo {

    public Pattern getTokenPattern() {
        return Pattern.compile("\\(");
    }

    public Token createToken(String token, int line, int column) {
        return new LeftBracketToken(token, line, column);
    }

}
