
package jp.sourceforge.torkenizer.test;

import java.util.regex.Pattern;

import jp.sourceforge.tokenizer.Token;
import jp.sourceforge.tokenizer.TokenInfo;

/**
 * 数値のトークン情報です。
 * 
 * @author uguu@users.sourceforge.jp
 */
public class NumberTokenInfo implements TokenInfo {

    public Pattern getTokenPattern() {
        return Pattern.compile("[0-9]+(\\.[0-9]+)?");
    }

    public Token createToken(String token, int line, int column) {
        return new NumberToken(token, line, column);
    }

}
