/*
 * Copyright (C) 2006 uguu@users.sourceforge.jp, All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. Neither the name of Clarkware Consulting, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without prior written permission. For written
 *       permission, please contact clarkware@clarkware.com.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * CLARKWARE CONSULTING OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN  ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.rpn_computer;

import jp.sourceforge.rpn_computer.node.ExpressionStatementNode;
import jp.sourceforge.tokenizer.Tokenizer;

/**
 * <p>
 * 通常の数式を解析し、抽象構文木を構築します。
 * </p>
 * 
 * @author uguu@users.sourceforge.jp
 */
public final class RpnParser {

    /**
     * <p>
     * 通常の数式を解析し、抽象構文木を構築します。
     * </p>
     * <p>
     * 字句解析に失敗した場合、{@link jp.sourceforge.tokenizer.TokenizerException}例外をスローします。構文解析に失敗した場合、{@link ParseException}例外をスローします。
     * </p>
     * 
     * @param expression
     *            通常の数式。nullの場合、{@link NullPointerException}例外をスローします。
     * @return 解析した結果の抽象構文木。
     */
    public RpnNode parse(String expression) {
        // 引数をチェックします。
        if (expression == null) {
            throw new NullPointerException("expressionがnullです。");
        }
        // 構文解析します。
        Tokenizer tokenizer = new Tokenizer(expression);
        RpnNode node = new ExpressionStatementNode();
        node.parse(tokenizer);
        return node;
    }
}
