/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.expression_computer.node;

import java.util.ArrayList;
import jp.sourceforge.expression_computer.CompileContext;
import jp.sourceforge.expression_computer.Node;
import jp.sourceforge.expression_computer.command.ConditionalOrCommand;
import jp.sourceforge.expression_computer.node.AbstractNode;
import jp.sourceforge.expression_computer.node.OperandNode;

public final class ConditionalOrExpressionNode
extends AbstractNode
implements OperandNode {
    private Node[] nodes;

    public ConditionalOrExpressionNode(Node[] nodes) {
        if (nodes == null) {
            throw new NullPointerException("nodes\u304cnull\u3067\u3059\u3002");
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] != null) continue;
            throw new NullPointerException("nodes[" + i + "]\u304cnull\u3067\u3059\u3002");
        }
        if (nodes.length < 2) {
            throw new IllegalArgumentException("nodes.length < 2\u3067\u3059\u3002");
        }
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (int i = 0; i < nodes.length; ++i) {
            if (i > 0) {
                nodeList.add(new OperatorNode());
            }
            nodeList.add(nodes[i]);
        }
        this.nodes = nodeList.toArray(new Node[0]);
    }

    public void compile(CompileContext context) {
        this.nodes[0].compile(context);
        for (int i = 2; i < this.nodes.length; i += 2) {
            this.nodes[i].compile(context);
            this.nodes[i - 1].compile(context);
        }
    }

    public Node[] getChildren() {
        return (Node[])this.nodes.clone();
    }

    public String toString() {
        return this.getClass().getName() + this.toChildrenString();
    }

    public static final class OperatorNode
    extends AbstractNode {
        public void compile(CompileContext context) {
            context.add(new ConditionalOrCommand());
        }

        public Node[] getChildren() {
            return new Node[0];
        }

        public String toString() {
            return this.getClass().getName();
        }
    }
}

