/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.expression_computer.node;

import jp.sourceforge.expression_computer.CompileContext;
import jp.sourceforge.expression_computer.Node;
import jp.sourceforge.expression_computer.command.PushStackCommand;
import jp.sourceforge.expression_computer.node.AbstractNode;
import jp.sourceforge.expression_computer.node.OperandNode;
import jp.sourceforge.expression_computer.util.Validator;

public final class IntegerLiteralNode
extends AbstractNode
implements OperandNode {
    private static final int RADIX_16 = 16;
    private static final int RADIX_8 = 8;
    private String value;

    public IntegerLiteralNode(String value) {
        if (value == null) {
            throw new NullPointerException("value\u304cnull\u3067\u3059\u3002");
        }
        if (!Validator.isIntegerLiteral(value)) {
            throw new IllegalArgumentException("value\u304c\u6574\u6570\u5024\u306e\u5f62\u5f0f\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        this.value = value;
    }

    public void compile(CompileContext context) {
        long value = this.value.startsWith("0x") ? Long.parseLong(this.value.substring("0x".length()), 16) : (this.value.startsWith("0") && this.value.length() > 1 ? Long.parseLong(this.value.substring("0".length()), 8) : Long.parseLong(this.value));
        context.add(new PushStackCommand(value));
    }

    public Node[] getChildren() {
        return new Node[0];
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.value + "]";
    }
}

