/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.expression_computer;

import java.io.StringReader;
import java.util.ArrayList;
import jp.sourceforge.expression_computer.javacc.ASTAdditiveExpression;
import jp.sourceforge.expression_computer.javacc.ASTAdditiveExpressionOperator;
import jp.sourceforge.expression_computer.javacc.ASTAndExpression;
import jp.sourceforge.expression_computer.javacc.ASTAssignmentExpression;
import jp.sourceforge.expression_computer.javacc.ASTAssignmentExpressionOperator;
import jp.sourceforge.expression_computer.javacc.ASTConditionalAndExpression;
import jp.sourceforge.expression_computer.javacc.ASTConditionalExpression;
import jp.sourceforge.expression_computer.javacc.ASTConditionalOrExpression;
import jp.sourceforge.expression_computer.javacc.ASTEqualityExpression;
import jp.sourceforge.expression_computer.javacc.ASTEqualityExpressionOperator;
import jp.sourceforge.expression_computer.javacc.ASTExclusiveOrExpression;
import jp.sourceforge.expression_computer.javacc.ASTExpression;
import jp.sourceforge.expression_computer.javacc.ASTFloatingPointLiteral;
import jp.sourceforge.expression_computer.javacc.ASTFunctionExpression;
import jp.sourceforge.expression_computer.javacc.ASTFunctionName;
import jp.sourceforge.expression_computer.javacc.ASTInclusiveOrExpression;
import jp.sourceforge.expression_computer.javacc.ASTIntegerLiteral;
import jp.sourceforge.expression_computer.javacc.ASTMultiplicativeExpression;
import jp.sourceforge.expression_computer.javacc.ASTMultiplicativeExpressionOperator;
import jp.sourceforge.expression_computer.javacc.ASTParenthesesExpression;
import jp.sourceforge.expression_computer.javacc.ASTPostDecrementExpression;
import jp.sourceforge.expression_computer.javacc.ASTPostIncrementExpression;
import jp.sourceforge.expression_computer.javacc.ASTPreDecrementExpression;
import jp.sourceforge.expression_computer.javacc.ASTPreIncrementExpression;
import jp.sourceforge.expression_computer.javacc.ASTRelationalExpression;
import jp.sourceforge.expression_computer.javacc.ASTRelationalExpressionOperator;
import jp.sourceforge.expression_computer.javacc.ASTShiftExpression;
import jp.sourceforge.expression_computer.javacc.ASTShiftExpressionOperator;
import jp.sourceforge.expression_computer.javacc.ASTUnaryExpression;
import jp.sourceforge.expression_computer.javacc.ASTUnaryExpressionNotPlusMinus;
import jp.sourceforge.expression_computer.javacc.ASTUnaryExpressionNotPlusMinusOperator;
import jp.sourceforge.expression_computer.javacc.ASTUnaryExpressionOperator;
import jp.sourceforge.expression_computer.javacc.ASTVariable;
import jp.sourceforge.expression_computer.javacc.JavaCCParser;
import jp.sourceforge.expression_computer.javacc.Node;
import jp.sourceforge.expression_computer.javacc.ParseException;
import jp.sourceforge.expression_computer.javacc.SimpleNode;
import jp.sourceforge.expression_computer.node.AdditiveExpressionNode;
import jp.sourceforge.expression_computer.node.AndExpressionNode;
import jp.sourceforge.expression_computer.node.AssignmentExpressionNode;
import jp.sourceforge.expression_computer.node.BracketExpressionNode;
import jp.sourceforge.expression_computer.node.ConditionalAndExpressionNode;
import jp.sourceforge.expression_computer.node.ConditionalExpressionNode;
import jp.sourceforge.expression_computer.node.ConditionalOrExpressionNode;
import jp.sourceforge.expression_computer.node.EqualityExpressionNode;
import jp.sourceforge.expression_computer.node.ExclusiveOrExpressionNode;
import jp.sourceforge.expression_computer.node.ExpressionStatementNode;
import jp.sourceforge.expression_computer.node.FloatingPointLiteralNode;
import jp.sourceforge.expression_computer.node.FunctionExpressionNode;
import jp.sourceforge.expression_computer.node.InclusiveOrExpressionNode;
import jp.sourceforge.expression_computer.node.IntegerLiteralNode;
import jp.sourceforge.expression_computer.node.MultiplicativeExpressionNode;
import jp.sourceforge.expression_computer.node.OperandNode;
import jp.sourceforge.expression_computer.node.PostDecrementExpressionNode;
import jp.sourceforge.expression_computer.node.PostIncrementExpressionNode;
import jp.sourceforge.expression_computer.node.PreDecrementExpressionNode;
import jp.sourceforge.expression_computer.node.PreIncrementExpressionNode;
import jp.sourceforge.expression_computer.node.RelationalExpressionNode;
import jp.sourceforge.expression_computer.node.ShiftExpressionNode;
import jp.sourceforge.expression_computer.node.UnaryExpressionNode;
import jp.sourceforge.expression_computer.node.UnaryExpressionNotPlusMinusNode;
import jp.sourceforge.expression_computer.node.VariableNode;

public final class Parser {
    public jp.sourceforge.expression_computer.Node parse(String expression) {
        ASTExpression astExpressionNode;
        if (expression == null) {
            throw new NullPointerException("expression\u304cnull\u3067\u3059\u3002");
        }
        JavaCCParser javaCCParser = new JavaCCParser(new StringReader(expression));
        try {
            astExpressionNode = (ASTExpression)javaCCParser.parse();
        }
        catch (ParseException e) {
            throw new jp.sourceforge.expression_computer.ParseException(e);
        }
        jp.sourceforge.expression_computer.Node node = this.buildRpnNode(astExpressionNode);
        return node;
    }

    private jp.sourceforge.expression_computer.Node buildRpnNode(Node node) {
        if (node instanceof ASTExpression) {
            if (node.jjtGetNumChildren() == 0) {
                return new ExpressionStatementNode();
            }
            OperandNode operand = (OperandNode)this.buildRpnNode(node.jjtGetChild(0));
            return new ExpressionStatementNode(operand);
        }
        if (node instanceof ASTAssignmentExpression) {
            VariableNode operand1 = (VariableNode)this.buildRpnNode(node.jjtGetChild(0));
            AssignmentExpressionNode.OperatorNode operator = (AssignmentExpressionNode.OperatorNode)this.buildRpnNode(node.jjtGetChild(1));
            OperandNode operand2 = (OperandNode)this.buildRpnNode(node.jjtGetChild(2));
            return new AssignmentExpressionNode(operand1, operator, operand2);
        }
        if (node instanceof ASTAssignmentExpressionOperator) {
            ASTAssignmentExpressionOperator ope = (ASTAssignmentExpressionOperator)node;
            if ("=".equals(ope.getNodeValue())) {
                return new AssignmentExpressionNode.EqualNode();
            }
            if ("+=".equals(ope.getNodeValue())) {
                return new AssignmentExpressionNode.AddEqualNode();
            }
            if ("-=".equals(ope.getNodeValue())) {
                return new AssignmentExpressionNode.SubtractEqualNode();
            }
            if ("*=".equals(ope.getNodeValue())) {
                return new AssignmentExpressionNode.MultiplyEqualNode();
            }
            if ("/=".equals(ope.getNodeValue())) {
                return new AssignmentExpressionNode.DivideEqualNode();
            }
            if ("%=".equals(ope.getNodeValue())) {
                return new AssignmentExpressionNode.SurplusEqualNode();
            }
            if ("&=".equals(ope.getNodeValue())) {
                return new AssignmentExpressionNode.AndEqualNode();
            }
            if ("^=".equals(ope.getNodeValue())) {
                return new AssignmentExpressionNode.ExclusiveOrEqualNode();
            }
            if ("|=".equals(ope.getNodeValue())) {
                return new AssignmentExpressionNode.InclusiveOrEqualNode();
            }
            if ("<<=".equals(ope.getNodeValue())) {
                return new AssignmentExpressionNode.LeftShiftEqualNode();
            }
            if (">>=".equals(ope.getNodeValue())) {
                return new AssignmentExpressionNode.ArithmeticRightShiftEqualNode();
            }
            if (">>>=".equals(ope.getNodeValue())) {
                return new AssignmentExpressionNode.LogicalRightShiftEqualNode();
            }
            throw new jp.sourceforge.expression_computer.ParseException(ope.getNodeValue(), ope.getNodeLine(), ope.getNodeColumn());
        }
        if (node instanceof ASTConditionalExpression) {
            OperandNode operand1 = (OperandNode)this.buildRpnNode(node.jjtGetChild(0));
            OperandNode operand2 = (OperandNode)this.buildRpnNode(node.jjtGetChild(1));
            OperandNode operand3 = (OperandNode)this.buildRpnNode(node.jjtGetChild(2));
            return new ConditionalExpressionNode(operand1, operand2, operand3);
        }
        if (node instanceof ASTConditionalOrExpression) {
            jp.sourceforge.expression_computer.Node[] operands = new OperandNode[node.jjtGetNumChildren()];
            for (int i = 0; i < operands.length; ++i) {
                operands[i] = (OperandNode)this.buildRpnNode(node.jjtGetChild(i));
            }
            return new ConditionalOrExpressionNode(operands);
        }
        if (node instanceof ASTConditionalAndExpression) {
            jp.sourceforge.expression_computer.Node[] operands = new OperandNode[node.jjtGetNumChildren()];
            for (int i = 0; i < operands.length; ++i) {
                operands[i] = (OperandNode)this.buildRpnNode(node.jjtGetChild(i));
            }
            return new ConditionalAndExpressionNode(operands);
        }
        if (node instanceof ASTInclusiveOrExpression) {
            OperandNode[] operands = new OperandNode[node.jjtGetNumChildren()];
            for (int i = 0; i < operands.length; ++i) {
                operands[i] = (OperandNode)this.buildRpnNode(node.jjtGetChild(i));
            }
            return new InclusiveOrExpressionNode(operands);
        }
        if (node instanceof ASTExclusiveOrExpression) {
            OperandNode[] operands = new OperandNode[node.jjtGetNumChildren()];
            for (int i = 0; i < operands.length; ++i) {
                operands[i] = (OperandNode)this.buildRpnNode(node.jjtGetChild(i));
            }
            return new ExclusiveOrExpressionNode(operands);
        }
        if (node instanceof ASTAndExpression) {
            jp.sourceforge.expression_computer.Node[] operands = new OperandNode[node.jjtGetNumChildren()];
            for (int i = 0; i < operands.length; ++i) {
                operands[i] = (OperandNode)this.buildRpnNode(node.jjtGetChild(i));
            }
            return new AndExpressionNode(operands);
        }
        if (node instanceof ASTEqualityExpression) {
            jp.sourceforge.expression_computer.Node[] nodes = new jp.sourceforge.expression_computer.Node[node.jjtGetNumChildren()];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = this.buildRpnNode(node.jjtGetChild(i));
            }
            return new EqualityExpressionNode(nodes);
        }
        if (node instanceof ASTEqualityExpressionOperator) {
            ASTEqualityExpressionOperator ope = (ASTEqualityExpressionOperator)node;
            if ("==".equals(ope.getNodeValue())) {
                return new EqualityExpressionNode.EqualNode();
            }
            if ("!=".equals(ope.getNodeValue())) {
                return new EqualityExpressionNode.NotEqualNode();
            }
            throw new jp.sourceforge.expression_computer.ParseException(ope.getNodeValue(), ope.getNodeLine(), ope.getNodeColumn());
        }
        if (node instanceof ASTRelationalExpression) {
            jp.sourceforge.expression_computer.Node[] nodes = new jp.sourceforge.expression_computer.Node[node.jjtGetNumChildren()];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = this.buildRpnNode(node.jjtGetChild(i));
            }
            return new RelationalExpressionNode(nodes);
        }
        if (node instanceof ASTRelationalExpressionOperator) {
            ASTRelationalExpressionOperator ope = (ASTRelationalExpressionOperator)node;
            if (">".equals(ope.getNodeValue())) {
                return new RelationalExpressionNode.GreaterThanNode();
            }
            if ("<".equals(ope.getNodeValue())) {
                return new RelationalExpressionNode.LessThanNode();
            }
            if (">=".equals(ope.getNodeValue())) {
                return new RelationalExpressionNode.GreaterThanEqualNode();
            }
            if ("<=".equals(ope.getNodeValue())) {
                return new RelationalExpressionNode.LessThanEqualNode();
            }
            throw new jp.sourceforge.expression_computer.ParseException(ope.getNodeValue(), ope.getNodeLine(), ope.getNodeColumn());
        }
        if (node instanceof ASTShiftExpression) {
            jp.sourceforge.expression_computer.Node[] nodes = new jp.sourceforge.expression_computer.Node[node.jjtGetNumChildren()];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = this.buildRpnNode(node.jjtGetChild(i));
            }
            return new ShiftExpressionNode(nodes);
        }
        if (node instanceof ASTShiftExpressionOperator) {
            ASTShiftExpressionOperator ope = (ASTShiftExpressionOperator)node;
            if ("<<".equals(ope.getNodeValue())) {
                return new ShiftExpressionNode.LeftShiftNode();
            }
            if (">>".equals(ope.getNodeValue())) {
                return new ShiftExpressionNode.ArithmeticRightShiftNode();
            }
            if (">>>".equals(ope.getNodeValue())) {
                return new ShiftExpressionNode.LogicalRightShiftNode();
            }
            throw new jp.sourceforge.expression_computer.ParseException(ope.getNodeValue(), ope.getNodeLine(), ope.getNodeColumn());
        }
        if (node instanceof ASTAdditiveExpression) {
            jp.sourceforge.expression_computer.Node[] nodes = new jp.sourceforge.expression_computer.Node[node.jjtGetNumChildren()];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = this.buildRpnNode(node.jjtGetChild(i));
            }
            return new AdditiveExpressionNode(nodes);
        }
        if (node instanceof ASTAdditiveExpressionOperator) {
            ASTAdditiveExpressionOperator ope = (ASTAdditiveExpressionOperator)node;
            if ("+".equals(ope.getNodeValue())) {
                return new AdditiveExpressionNode.AddNode();
            }
            if ("-".equals(ope.getNodeValue())) {
                return new AdditiveExpressionNode.SubtractNode();
            }
            throw new jp.sourceforge.expression_computer.ParseException(ope.getNodeValue(), ope.getNodeLine(), ope.getNodeColumn());
        }
        if (node instanceof ASTMultiplicativeExpression) {
            jp.sourceforge.expression_computer.Node[] nodes = new jp.sourceforge.expression_computer.Node[node.jjtGetNumChildren()];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = this.buildRpnNode(node.jjtGetChild(i));
            }
            return new MultiplicativeExpressionNode(nodes);
        }
        if (node instanceof ASTMultiplicativeExpressionOperator) {
            ASTMultiplicativeExpressionOperator ope = (ASTMultiplicativeExpressionOperator)node;
            if ("*".equals(ope.getNodeValue())) {
                return new MultiplicativeExpressionNode.MultiplyNode();
            }
            if ("/".equals(ope.getNodeValue())) {
                return new MultiplicativeExpressionNode.DivideNode();
            }
            if ("%".equals(ope.getNodeValue())) {
                return new MultiplicativeExpressionNode.SurplusNode();
            }
            throw new jp.sourceforge.expression_computer.ParseException(ope.getNodeValue(), ope.getNodeLine(), ope.getNodeColumn());
        }
        if (node instanceof ASTUnaryExpression) {
            UnaryExpressionNode.OperatorNode operator = (UnaryExpressionNode.OperatorNode)this.buildRpnNode(node.jjtGetChild(0));
            OperandNode operand = (OperandNode)this.buildRpnNode(node.jjtGetChild(1));
            return new UnaryExpressionNode(operator, operand);
        }
        if (node instanceof ASTUnaryExpressionOperator) {
            ASTUnaryExpressionOperator ope = (ASTUnaryExpressionOperator)node;
            if ("+".equals(ope.getNodeValue())) {
                return new UnaryExpressionNode.PlusSignNode();
            }
            if ("-".equals(ope.getNodeValue())) {
                return new UnaryExpressionNode.MinusSignNode();
            }
            throw new jp.sourceforge.expression_computer.ParseException(ope.getNodeValue(), ope.getNodeLine(), ope.getNodeColumn());
        }
        if (node instanceof ASTPreIncrementExpression) {
            VariableNode operand = (VariableNode)this.buildRpnNode(node.jjtGetChild(0));
            return new PreIncrementExpressionNode(operand);
        }
        if (node instanceof ASTPreDecrementExpression) {
            VariableNode operand = (VariableNode)this.buildRpnNode(node.jjtGetChild(0));
            return new PreDecrementExpressionNode(operand);
        }
        if (node instanceof ASTUnaryExpressionNotPlusMinus) {
            UnaryExpressionNotPlusMinusNode.OperatorNode operator = (UnaryExpressionNotPlusMinusNode.OperatorNode)this.buildRpnNode(node.jjtGetChild(0));
            OperandNode operand = (OperandNode)this.buildRpnNode(node.jjtGetChild(1));
            return new UnaryExpressionNotPlusMinusNode(operator, operand);
        }
        if (node instanceof ASTUnaryExpressionNotPlusMinusOperator) {
            ASTUnaryExpressionNotPlusMinusOperator ope = (ASTUnaryExpressionNotPlusMinusOperator)node;
            if ("~".equals(ope.getNodeValue())) {
                return new UnaryExpressionNotPlusMinusNode.BitReversingNode();
            }
            if ("!".equals(ope.getNodeValue())) {
                return new UnaryExpressionNotPlusMinusNode.NotNode();
            }
            throw new jp.sourceforge.expression_computer.ParseException(ope.getNodeValue(), ope.getNodeLine(), ope.getNodeColumn());
        }
        if (node instanceof ASTPostIncrementExpression) {
            VariableNode operand = (VariableNode)this.buildRpnNode(node.jjtGetChild(0));
            return new PostIncrementExpressionNode(operand);
        }
        if (node instanceof ASTPostDecrementExpression) {
            VariableNode operand = (VariableNode)this.buildRpnNode(node.jjtGetChild(0));
            return new PostDecrementExpressionNode(operand);
        }
        if (node instanceof ASTIntegerLiteral) {
            ASTIntegerLiteral integerLiteral = (ASTIntegerLiteral)node;
            return new IntegerLiteralNode(integerLiteral.getNodeValue());
        }
        if (node instanceof ASTFloatingPointLiteral) {
            ASTFloatingPointLiteral floatingPointLiteral = (ASTFloatingPointLiteral)node;
            return new FloatingPointLiteralNode(floatingPointLiteral.getNodeValue());
        }
        if (node instanceof ASTFunctionExpression) {
            FunctionExpressionNode.FunctionNameNode functionName = (FunctionExpressionNode.FunctionNameNode)this.buildRpnNode(node.jjtGetChild(0));
            ArrayList<OperandNode> argumentList = new ArrayList<OperandNode>();
            for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
                OperandNode operand = (OperandNode)this.buildRpnNode(node.jjtGetChild(i));
                argumentList.add(operand);
            }
            OperandNode[] arguments = argumentList.toArray(new OperandNode[0]);
            return new FunctionExpressionNode(functionName, arguments);
        }
        if (node instanceof ASTFunctionName) {
            ASTFunctionName functionName = (ASTFunctionName)node;
            return new FunctionExpressionNode.FunctionNameNode(functionName.getNodeValue());
        }
        if (node instanceof ASTVariable) {
            ASTVariable variable = (ASTVariable)node;
            return new VariableNode(variable.getNodeValue());
        }
        if (node instanceof ASTParenthesesExpression) {
            OperandNode expression = (OperandNode)this.buildRpnNode(node.jjtGetChild(0));
            return new BracketExpressionNode(expression);
        }
        SimpleNode simpleNode = (SimpleNode)node;
        throw new jp.sourceforge.expression_computer.ParseException(simpleNode.getNodeValue(), simpleNode.getNodeLine(), simpleNode.getNodeColumn());
    }
}

