/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.expression_computer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import jp.sourceforge.expression_computer.Command;
import jp.sourceforge.expression_computer.CommandList;
import jp.sourceforge.expression_computer.ComputeObject;
import jp.sourceforge.expression_computer.command.AddCommand;
import jp.sourceforge.expression_computer.command.AndCommand;
import jp.sourceforge.expression_computer.command.ArithmeticRightShiftCommand;
import jp.sourceforge.expression_computer.command.BitReversingCommand;
import jp.sourceforge.expression_computer.command.ConditionCommand;
import jp.sourceforge.expression_computer.command.ConditionalAndCommand;
import jp.sourceforge.expression_computer.command.ConditionalOrCommand;
import jp.sourceforge.expression_computer.command.DivideCommand;
import jp.sourceforge.expression_computer.command.EqualCommand;
import jp.sourceforge.expression_computer.command.ExclusiveOrCommand;
import jp.sourceforge.expression_computer.command.FunctionCallCommand;
import jp.sourceforge.expression_computer.command.GreaterThanCommand;
import jp.sourceforge.expression_computer.command.GreaterThanEqualCommand;
import jp.sourceforge.expression_computer.command.InclusiveOrCommand;
import jp.sourceforge.expression_computer.command.LeftShiftCommand;
import jp.sourceforge.expression_computer.command.LessThanCommand;
import jp.sourceforge.expression_computer.command.LessThanEqualCommand;
import jp.sourceforge.expression_computer.command.LogicalRightShiftCommand;
import jp.sourceforge.expression_computer.command.MultiplyCommand;
import jp.sourceforge.expression_computer.command.NotCommand;
import jp.sourceforge.expression_computer.command.NotEqualCommand;
import jp.sourceforge.expression_computer.command.PostDecrementCommand;
import jp.sourceforge.expression_computer.command.PostIncrementCommand;
import jp.sourceforge.expression_computer.command.PreDecrementCommand;
import jp.sourceforge.expression_computer.command.PreIncrementCommand;
import jp.sourceforge.expression_computer.command.PushStackCommand;
import jp.sourceforge.expression_computer.command.SetVariableCommand;
import jp.sourceforge.expression_computer.command.SignReversingCommand;
import jp.sourceforge.expression_computer.command.SubtractCommand;
import jp.sourceforge.expression_computer.command.SurplusCommand;
import jp.sourceforge.expression_computer.type.FloatingPointLiteral;
import jp.sourceforge.expression_computer.type.IntegerLiteral;
import jp.sourceforge.expression_computer.type.Variable;

public final class Serializer {
    private static final byte EOF = 127;
    private static final byte COMMAND_ADD = 0;
    private static final byte COMMAND_AND = 1;
    private static final byte COMMAND_ARITHMETIC_RIGHT_SHIFT = 2;
    private static final byte COMMAND_BIT_REVERSING = 3;
    private static final byte COMMAND_CONDITIONAL_AND = 4;
    private static final byte COMMAND_CONDITIONAL_OR = 5;
    private static final byte COMMAND_CONDITION = 6;
    private static final byte COMMAND_DIVIDE = 7;
    private static final byte COMMAND_EQUAL = 8;
    private static final byte COMMAND_EXCLUSIVE_OR = 9;
    private static final byte COMMAND_FUNCTION_CALL = 10;
    private static final byte COMMAND_GREATER_THAN = 11;
    private static final byte COMMAND_GREATER_THAN_EQUAL = 12;
    private static final byte COMMAND_INCLUSIVE_OR = 13;
    private static final byte COMMAND_LEFT_SHIFT = 14;
    private static final byte COMMAND_LESS_THAN = 15;
    private static final byte COMMAND_LESS_THAN_EQUAL = 16;
    private static final byte COMMAND_LOGICAL_RIGHT_SHIFT = 17;
    private static final byte COMMAND_MULTIPLY = 18;
    private static final byte COMMAND_NOT = 19;
    private static final byte COMMAND_NOT_EQUAL = 20;
    private static final byte COMMAND_POST_DECREMENT = 21;
    private static final byte COMMAND_POST_INCREMENT = 22;
    private static final byte COMMAND_PRE_DECREMENT = 23;
    private static final byte COMMAND_PRE_INCREMENT = 24;
    private static final byte COMMAND_PUSH_STACK = 25;
    private static final byte COMMAND_SET_VARIABLE = 26;
    private static final byte COMMAND_SIGN_REVERSING = 27;
    private static final byte COMMAND_SUBTRACT = 28;
    private static final byte COMMAND_SURPLUS = 29;
    private static final byte TYPE_FLOATING_POINT_LITERAL = 0;
    private static final byte TYPE_INTEGER_LITERAL = 1;
    private static final byte TYPE_VARIABLE = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(CommandList commandList) throws IOException {
        if (commandList == null) {
            throw new NullPointerException("commandList\u304cnull\u3067\u3059\u3002");
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objOut = new ObjectOutputStream(byteOut);
            try {
                Iterator i = commandList.iterator();
                while (i.hasNext()) {
                    Command c = (Command)i.next();
                    if (c instanceof AddCommand) {
                        objOut.writeByte(0);
                        continue;
                    }
                    if (c instanceof AndCommand) {
                        objOut.writeByte(1);
                        continue;
                    }
                    if (c instanceof ArithmeticRightShiftCommand) {
                        objOut.writeByte(2);
                        continue;
                    }
                    if (c instanceof BitReversingCommand) {
                        objOut.writeByte(3);
                        continue;
                    }
                    if (c instanceof ConditionalAndCommand) {
                        objOut.writeByte(4);
                        continue;
                    }
                    if (c instanceof ConditionalOrCommand) {
                        objOut.writeByte(5);
                        continue;
                    }
                    if (c instanceof ConditionCommand) {
                        objOut.writeByte(6);
                        continue;
                    }
                    if (c instanceof DivideCommand) {
                        objOut.writeByte(7);
                        continue;
                    }
                    if (c instanceof EqualCommand) {
                        objOut.writeByte(8);
                        continue;
                    }
                    if (c instanceof ExclusiveOrCommand) {
                        objOut.writeByte(9);
                        continue;
                    }
                    if (c instanceof FunctionCallCommand) {
                        objOut.writeByte(10);
                        FunctionCallCommand funcCall = (FunctionCallCommand)c;
                        objOut.writeUTF(funcCall.getName());
                        objOut.writeInt(funcCall.getArgumentNumber());
                        continue;
                    }
                    if (c instanceof GreaterThanCommand) {
                        objOut.writeByte(11);
                        continue;
                    }
                    if (c instanceof GreaterThanEqualCommand) {
                        objOut.writeByte(12);
                        continue;
                    }
                    if (c instanceof InclusiveOrCommand) {
                        objOut.writeByte(13);
                        continue;
                    }
                    if (c instanceof LeftShiftCommand) {
                        objOut.writeByte(14);
                        continue;
                    }
                    if (c instanceof LessThanCommand) {
                        objOut.writeByte(15);
                        continue;
                    }
                    if (c instanceof LessThanEqualCommand) {
                        objOut.writeByte(16);
                        continue;
                    }
                    if (c instanceof LogicalRightShiftCommand) {
                        objOut.writeByte(17);
                        continue;
                    }
                    if (c instanceof MultiplyCommand) {
                        objOut.writeByte(18);
                        continue;
                    }
                    if (c instanceof NotCommand) {
                        objOut.writeByte(19);
                        continue;
                    }
                    if (c instanceof NotEqualCommand) {
                        objOut.writeByte(20);
                        continue;
                    }
                    if (c instanceof PostDecrementCommand) {
                        objOut.writeByte(21);
                        continue;
                    }
                    if (c instanceof PostIncrementCommand) {
                        objOut.writeByte(22);
                        continue;
                    }
                    if (c instanceof PreDecrementCommand) {
                        objOut.writeByte(23);
                        continue;
                    }
                    if (c instanceof PreIncrementCommand) {
                        objOut.writeByte(24);
                        continue;
                    }
                    if (c instanceof PushStackCommand) {
                        objOut.writeByte(25);
                        PushStackCommand pushStack = (PushStackCommand)c;
                        ComputeObject compObj = pushStack.getValue();
                        if (compObj instanceof FloatingPointLiteral) {
                            objOut.writeByte(0);
                            objOut.writeDouble(compObj.getValue(null));
                            continue;
                        }
                        if (compObj instanceof IntegerLiteral) {
                            objOut.writeByte(1);
                            objOut.writeLong((long)compObj.getValue(null));
                            continue;
                        }
                        if (compObj instanceof Variable) {
                            objOut.writeByte(2);
                            objOut.writeUTF(((Variable)compObj).getName());
                            continue;
                        }
                        throw new IOException("\u4e0d\u660e\u306a\u8a08\u7b97\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3067\u3059\u3002{" + compObj + "}");
                    }
                    if (c instanceof SetVariableCommand) {
                        objOut.writeByte(26);
                        continue;
                    }
                    if (c instanceof SignReversingCommand) {
                        objOut.writeByte(27);
                        continue;
                    }
                    if (c instanceof SubtractCommand) {
                        objOut.writeByte(28);
                        continue;
                    }
                    if (c instanceof SurplusCommand) {
                        objOut.writeByte(29);
                        continue;
                    }
                    throw new IOException("\u4e0d\u660e\u306a\u30b3\u30de\u30f3\u30c9\u3067\u3059\u3002{" + c + "}");
                }
                objOut.writeByte(127);
            }
            finally {
                objOut.close();
            }
        }
        finally {
            byteOut.close();
        }
        return byteOut.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public CommandList deserialize(byte[] data) throws IOException {
        if (data == null) {
            throw new NullPointerException("data\u304cnull\u3067\u3059\u3002");
        }
        CommandList cl = new CommandList();
        ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
        try {
            ObjectInputStream objIn = new ObjectInputStream(byteIn);
            try {
                byte commandType;
                while ((commandType = objIn.readByte()) != 127) {
                    void var5_5;
                    switch (commandType) {
                        case 0: {
                            Command c = new AddCommand();
                            break;
                        }
                        case 1: {
                            Command c = new AndCommand();
                            break;
                        }
                        case 2: {
                            Command c = new ArithmeticRightShiftCommand();
                            break;
                        }
                        case 3: {
                            Command c = new BitReversingCommand();
                            break;
                        }
                        case 6: {
                            Command c = new ConditionCommand();
                            break;
                        }
                        case 4: {
                            Command c = new ConditionalAndCommand();
                            break;
                        }
                        case 5: {
                            Command c = new ConditionalOrCommand();
                            break;
                        }
                        case 7: {
                            Command c = new DivideCommand();
                            break;
                        }
                        case 8: {
                            Command c = new EqualCommand();
                            break;
                        }
                        case 9: {
                            Command c = new ExclusiveOrCommand();
                            break;
                        }
                        case 10: {
                            String name = objIn.readUTF();
                            int arguments = objIn.readInt();
                            Command c = new FunctionCallCommand(name, arguments);
                            break;
                        }
                        case 11: {
                            Command c = new GreaterThanCommand();
                            break;
                        }
                        case 12: {
                            Command c = new GreaterThanEqualCommand();
                            break;
                        }
                        case 13: {
                            Command c = new InclusiveOrCommand();
                            break;
                        }
                        case 14: {
                            Command c = new LeftShiftCommand();
                            break;
                        }
                        case 15: {
                            Command c = new LessThanCommand();
                            break;
                        }
                        case 16: {
                            Command c = new LessThanEqualCommand();
                            break;
                        }
                        case 17: {
                            Command c = new LogicalRightShiftCommand();
                            break;
                        }
                        case 18: {
                            Command c = new MultiplyCommand();
                            break;
                        }
                        case 19: {
                            Command c = new NotCommand();
                            break;
                        }
                        case 20: {
                            Command c = new NotEqualCommand();
                            break;
                        }
                        case 21: {
                            Command c = new PostDecrementCommand();
                            break;
                        }
                        case 22: {
                            Command c = new PostIncrementCommand();
                            break;
                        }
                        case 23: {
                            Command c = new PreDecrementCommand();
                            break;
                        }
                        case 24: {
                            Command c = new PreIncrementCommand();
                            break;
                        }
                        case 25: {
                            void var9_9;
                            byte compObjType = objIn.readByte();
                            switch (compObjType) {
                                case 0: {
                                    ComputeObject compObj = new FloatingPointLiteral(objIn.readDouble());
                                    break;
                                }
                                case 1: {
                                    ComputeObject compObj = new IntegerLiteral(objIn.readLong());
                                    break;
                                }
                                case 2: {
                                    ComputeObject compObj = new Variable(objIn.readUTF());
                                    break;
                                }
                                default: {
                                    throw new IOException("\u4e0d\u660e\u306a\u8a08\u7b97\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u7a2e\u985e\u3067\u3059\u3002{" + compObjType + "}");
                                }
                            }
                            Command c = new PushStackCommand((ComputeObject)var9_9);
                            break;
                        }
                        case 26: {
                            Command c = new SetVariableCommand();
                            break;
                        }
                        case 27: {
                            Command c = new SignReversingCommand();
                            break;
                        }
                        case 28: {
                            Command c = new SubtractCommand();
                            break;
                        }
                        case 29: {
                            Command c = new SurplusCommand();
                            break;
                        }
                        default: {
                            throw new IOException("\u4e0d\u660e\u306a\u30b3\u30de\u30f3\u30c9\u306e\u7a2e\u985e\u3067\u3059\u3002{" + commandType + "}");
                        }
                    }
                    cl.add((Object)var5_5);
                }
            }
            finally {
                objIn.close();
            }
        }
        finally {
            byteIn.close();
        }
        return cl;
    }
}

