/'
   Copyright (c)2022 vasile eodor nastasa
   rqwork7.com, rqwork.de, rqwork.ro
   nastasa.eodor@gmail.com
'/

#include once "windows.bi"

type PList as QList ptr
type PStringList as QStringList ptr

Type QList extends object
      public:
      as integer count
      As Any Ptr objects(Any)
      declare Sub Add(Item As Any Ptr)
      declare Sub Clear
      declare Sub Remove(byval Index As Integer)
      declare Sub Exchange(byval Index1 As Integer,byval Index2 As Integer)
      declare Sub Free
      declare Function IndexOf(Item As Any Ptr) As Integer
      declare Sub Insert(byval Index As Integer,Item As Any Ptr)
      declare destructor
End Type

type QStringList extends QList
     protected:
     as string ftext
     public:
     as string items(any)
     declare Sub Clear
     declare sub Add(as string,as any ptr=0)
     declare sub Insert(as integer,as string,as any ptr=0)
     declare Function IndexOf(as string) As Integer
     declare Function IndexOfObject(as any ptr) As Integer
     declare property Text as string
     declare property Text (as string)
     declare constructor
end type

/'Qlist'/
Sub QList.Add(Item As Any Ptr)
    this.Count += 1
    redim preserve this.objects(Count) as any ptr
    this.objects(this.Count -1) = Item
End Sub

Sub QList.Remove(byval Index As Integer)
    Dim i As Integer,x As Integer
    reDim Temp(this.Count -1) As Any Ptr
    x = 0
    For i = 0 to this.Count -1
         If i <> Index then
            Temp(x) = this.objects(i)
            x += 1
         End If
    Next i
    For i = 0 to Ubound(Temp)-1
          redim preserve item(i+1) as any ptr
         this.objects(i) = Temp(i)
    Next i
    this.Count -= 1
End Sub

Sub QList.Insert(byval Index As Integer,Item As Any Ptr)
    Dim i As Integer
    reDim Temp(this.Count + 1) As Any Ptr
    If (Index >= this.Count) or (Index < 0) then
       MessageBox GetActiveWindow ,"Out of range. Invalid string index.","QList",MB_ICONERROR
       Exit Sub
    End If
    For i = 0 to Index
        Temp(i) = this.objects(i)
    Next i
    Temp(Index) = Item
    For i = Index to this.Count -1
       Temp(i +1) = this.objects(i)
    Next i
    Erase this.objects
    this.Count += 1
    For i = 0 to this.Count -1
         this.objects(i) = Temp(i)
    Next i
End Sub

Sub QList.Exchange(byval Index1 As Integer,byval Index2 As Integer)
    Dim As Any Ptr it1,it2
    If (Index1 >= this.Count) or (Index1 < 0) or (Index2 >= this.Count) or (Index2 < 0) then
       MessageBox GetActiveWindow ,"Out of range. Invalid string index.","QList",MB_ICONERROR
       Exit Sub
    End If
    it1 = this.objects(Index1)
    it2 = this.objects(Index2)
    this.objects(Index1) = it2
    this.objects(Index2) = it1
End Sub

Function QList.IndexOf(Item As Any Ptr) As Integer
   Dim i As Integer
   Function = -1
   For i = 0 to this.Count -1
       If this.objects(i) = Item  then
          Function = i
          Exit For
       End If
   Next i
End Function

Sub QList.Clear
    Erase this.objects
    this.Count=0
End Sub

Sub QList.Free
    this.destructor
End Sub

destructor QList
end destructor

/' QStringList'/
sub QStringList.Insert(idx as integer,v as string,o as any ptr=0)
    Base.Insert(idx,o)
    redim Temp(Base.Count+1) As string 'ptr ptr
    If Idx<0 and Idx>Base.Count-1 then
       MessageBox GetActiveWindow ,"Out of range. Invalid string index.","QStringList",MB_ICONERROR
       Exit Sub
    End If
    For i as integer=0 to Idx
        Temp(i)=items(i)
    Next i
    Temp(Idx)=v
    For i as integer=idx to Base.Count -1
       Temp(i+1)=items(i)
    Next i
    Erase items
    For i as integer=0 to Base.Count -1
         items(i)=Temp(i)
    Next i
end sub

Function QStringList.IndexOf(v as string) As Integer
    if v="" then return -2
    for i as integer=0 to ubound(items)-1
        if lcase(items(i))=lcase(v) then return i
    next
    return -1
end function

Function QStringList.IndexOfObject(v as any ptr) As Integer
    return Base.indexof(v)
end function

Sub QStringList.Clear
    Base.Clear
    redim items(0)
    ftext=""
End Sub

sub QStringList.Add(v as string,o as any ptr=0)
    base.add(o)
    redim preserve items(base.count) as string
    items(base.count-1)=v
end sub

property QStringList.Text as string
    if Count>0 then
       for i as integer=0 to count-1
           if i<count-1 then
              ftext=ftext+items(i)+chr(10)
           elseif i=count-1 then
              ftext=ftext+items(i)+chr(0)
           end if
       next i
    else
       ftext=""
    end if
    return ftext
end property

property QStringList.Text (v as string)
    this.Clear
    dim as string t=""
    for i as integer=0 to len(v)-1
        t=t+chr(v[i])
        if v[i]=10 or i=len(v) then
           if i<len(v) then t=mid(t,1,len(t)-1)
           Add(t)
           t=""
        end if
    next
end property

constructor QStringList
end constructor