type QForm extends QCustomForm
    public:
    declare operator cast as any ptr
    declare constructor
end type

type QStatic extends QFrame
     protected:
     declare virtual sub Dispatch(byref as QMessage)
     declare virtual sub Handler(byref as QMessage)
     declare static function DlgProc(as hwnd,as uint,as wparam,as lparam) as lresult
     public:
     declare static function Register(v as string="QStatic") as integer
     declare operator cast as any ptr
     declare operator cast as string
     declare constructor
     declare destructor
     #ifdef rtl
     declare virtual function GetProperties as zstring ptr
     declare virtual function GetPropertyInfo(as string) as PELPropInfo
     declare virtual function GetProperty(as string) as zstring ptr
     declare virtual function SetProperty(as string,as zstring ptr) as boolean
    #endif
end type

type QButton extends QFrame
     protected:
     declare virtual sub Dispatch(byref as QMessage)
     declare virtual sub Handler(byref as QMessage)
     declare static function DlgProc(as hwnd,as uint,as wparam,as lparam) as lresult
     public:
     declare static function Register(v as string="QButton") as integer
     declare operator cast as any ptr
     declare operator cast as string
     declare constructor
     declare destructor
     #ifdef rtl
     declare virtual function GetProperties as zstring ptr
     declare virtual function GetPropertyInfo(as string) as PELPropInfo
     declare virtual function GetProperty(as string) as zstring ptr
     declare virtual function SetProperty(as string,as zstring ptr) as boolean
    #endif
end type

type QEdit extends QFrame
     protected:
     declare virtual sub Dispatch(byref as QMessage)
     declare virtual sub Handler(byref as QMessage)
     declare static function DlgProc(as hwnd,as uint,as wparam,as lparam) as lresult
     public:
     declare static function Register(v as string="QEdit") as integer
     declare operator cast as any ptr
     declare operator cast as string
     declare constructor
     declare destructor
     #ifdef rtl
     declare virtual function GetProperties as zstring ptr
     declare virtual function GetPropertyInfo(as string) as PELPropInfo
     declare virtual function GetProperty(as string) as zstring ptr
     declare virtual function SetProperty(as string,as zstring ptr) as boolean
    #endif
end type

type QComboBox extends QFrame
     protected:
     declare virtual sub Dispatch(byref as QMessage)
     declare virtual sub Handler(byref as QMessage)
     declare static function DlgProc(as hwnd,as uint,as wparam,as lparam) as lresult
     public:
     declare static function Register(v as string="QComboBox") as integer
     declare operator cast as any ptr
     declare operator cast as string
     declare constructor
     declare destructor
     #ifdef rtl
     declare virtual function GetProperties as zstring ptr
     declare virtual function GetPropertyInfo(as string) as PELPropInfo
     declare virtual function GetProperty(as string) as zstring ptr
     declare virtual function SetProperty(as string,as zstring ptr) as boolean
    #endif
end type

type QListBox extends QFrame
     protected:
     declare virtual sub Dispatch(byref as QMessage)
     declare virtual sub Handler(byref as QMessage)
     declare static function DlgProc(as hwnd,as uint,as wparam,as lparam) as lresult
     public:
     declare static function Register(v as string="QListBox") as integer
     declare operator cast as any ptr
     declare operator cast as string
     declare constructor
     declare destructor
     #ifdef rtl
     declare virtual function GetProperties as zstring ptr
     declare virtual function GetPropertyInfo(as string) as PELPropInfo
     declare virtual function GetProperty(as string) as zstring ptr
     declare virtual function SetProperty(as string,as zstring ptr) as boolean
    #endif
end type

type QScrollBar extends QFrame
     protected:
     declare virtual sub Dispatch(byref as QMessage)
     declare virtual sub Handler(byref as QMessage)
     declare static function DlgProc(as hwnd,as uint,as wparam,as lparam) as lresult
     public:
     declare static function Register(v as string="QScrollBar") as integer
     declare operator cast as any ptr
     declare operator cast as string
     declare constructor
     declare destructor
     #ifdef rtl
     declare virtual function GetProperties as zstring ptr
     declare virtual function GetPropertyInfo(as string) as PELPropInfo
     declare virtual function GetProperty(as string) as zstring ptr
     declare virtual function SetProperty(as string,as zstring ptr) as boolean
    #endif
end type

/'Register to ide'/
namespace Standards
    function RegisterComponents as zstring ptr export
        dim as string s="Standards=QStatic,QButton,QEdit,QComboBox,QListBox,QScrollBar"+chr(0)
        dim as zstring ptr result=callocate(len(s))
        *result=s
        return result
    end function
end namespace

/'QForm'/
operator QForm.cast as any ptr
    return @this
end operator

constructor QForm
end constructor

/'QStatic'/
#ifdef rtl
     function QStatic.GetProperties as zstring ptr
         dim as string s=*Base.GetProperties
         dim as zstring ptr zs=callocate(len(s))
         *zs=s
         return zs
     end function

     function QStatic.GetPropertyInfo(n as string) as PELPropInfo
         return Base.GetPropertyInfo(n)
     end function

     function QStatic.GetProperty(n as string) as zstring ptr
         return Base.GetProperty(n)
     end function

     function QStatic.SetProperty(n as string,v as zstring ptr) as boolean
         return Base.SetProperty(n,v)
     end function
#endif

sub QStatic.Handler(byref m as QMessage)
    Base.Handler(m)
end sub

sub QStatic.Dispatch(byref m as QMessage)
    base.Dispatch(m)
end sub

function QStatic.DlgProc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
    dim as PFrame F=iif(creationdata,creationdata,cast(PFrame,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-4)))
    dim as QMessage m=type(dlg,msg,wparam,lparam,0,F)
    if F then
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    else
       F=new QStatic
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    end if
    return m.result
end function

function QStatic.Register(v as string="QStatic") as integer
    dim as wndclassex wcls
    wcls.cbsize=sizeof(wcls)
    if getclassinfoex(0,"static",@wcls) then
       wcls.cbwndextra+=sizeof(integer)
       wcls.lpfnwndproc=@dlgproc
       wcls.lpszclassname=strptr(v)
       wcls.hinstance=instance
       return RegisterClassEx(@wcls)
    end if
    return 0
end function

operator QStatic.cast as any ptr
    return @this
end operator

operator QStatic.cast as string
    return iif(classname<>"",classname,"QStatic")
end operator

constructor QStatic
    classname="QStatic"
    classAncestor="static"
    fstyle=ws_child
    fwidth=97
    fheight=17
end constructor

destructor QStatic
end destructor

/'QButton'/
#ifdef rtl
     function QButton.GetProperties as zstring ptr
         dim as string s=*Base.GetProperties
         dim as zstring ptr zs=callocate(len(s))
         *zs=s
         return zs
     end function

     function QButton.GetPropertyInfo(n as string) as PELPropInfo
         return Base.GetPropertyInfo(n)
     end function

     function QButton.GetProperty(n as string) as zstring ptr
         return Base.GetProperty(n)
     end function

     function QButton.SetProperty(n as string,v as zstring ptr) as boolean
         return Base.SetProperty(n,v)
     end function
#endif

sub QButton.Handler(byref m as QMessage)
    Base.Handler(m)
end sub

sub QButton.Dispatch(byref m as QMessage)
    base.Dispatch(m)
    select case m.msg
    case cm_command
         if m.wparam=bn_clicked then click
    end select
end sub

function QButton.DlgProc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
    dim as PFrame F=iif(creationdata,creationdata,cast(PFrame,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-4)))
    dim as QMessage m=type(dlg,msg,wparam,lparam,0,F)
    if F then
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    else
       F=new QButton
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    end if
    return m.result
end function

function QButton.Register(v as string="QButton") as integer
    dim as wndclassex wcls
    wcls.cbsize=sizeof(wcls)
    if getclassinfoex(0,"button",@wcls) then
       wcls.cbwndextra+=sizeof(integer)
       wcls.lpfnwndproc=@dlgproc
       wcls.lpszclassname=strptr(v)
       wcls.hinstance=instance
       return RegisterClassEx(@wcls)
    end if
    return 0
end function

operator QButton.cast as any ptr
    return @this
end operator

operator QButton.cast as string
    return iif(classname<>"",classname,"QButton")
end operator

constructor QButton
    classname="QButton"
    classAncestor="Button"
    fstyle=ws_child
    fwidth=75
    fheight=35
end constructor

destructor QButton
end destructor

/'QEdit'/
#ifdef rtl
     function QEdit.GetProperties as zstring ptr
         dim as string s=*Base.GetProperties
         dim as zstring ptr zs=callocate(len(s))
         *zs=s
         return zs
     end function

     function QEdit.GetPropertyInfo(n as string) as PELPropInfo
         return Base.GetPropertyInfo(n)
     end function

     function QEdit.GetProperty(n as string) as zstring ptr
         return Base.GetProperty(n)
     end function

     function QEdit.SetProperty(n as string,v as zstring ptr) as boolean
         return Base.SetProperty(n,v)
     end function
#endif

sub QEdit.Handler(byref m as QMessage)
    Base.Handler(m)
end sub

sub QEdit.Dispatch(byref m as QMessage)
    base.Dispatch(m)
end sub

function QEdit.DlgProc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
    dim as PFrame F=iif(creationdata,creationdata,cast(PFrame,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-4)))
    dim as QMessage m=type(dlg,msg,wparam,lparam,0,F)
    if F then
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    else
       F=new QEdit
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    end if
    return m.result
end function

function QEdit.Register(v as string="QEdit") as integer
    dim as wndclassex wcls
    wcls.cbsize=sizeof(wcls)
    if getclassinfoex(0,"edit",@wcls) then
       wcls.cbwndextra+=sizeof(integer)
       wcls.lpfnwndproc=@dlgproc
       wcls.lpszclassname=strptr(v)
       wcls.hinstance=instance
       return RegisterClassEx(@wcls)
    end if
    return 0
end function

operator QEdit.cast as any ptr
    return @this
end operator

operator QEdit.cast as string
    return iif(classname<>"",classname,"QEdit")
end operator

constructor QEdit
    classname="QEdit"
    classAncestor="edit"
    fstyle=ws_child
    fwidth=97
    fheight=17
end constructor

destructor QEdit
end destructor

/'QComboBox'/
#ifdef rtl
     function QComboBox.GetProperties as zstring ptr
         dim as string s=*Base.GetProperties
         dim as zstring ptr zs=callocate(len(s))
         *zs=s
         return zs
     end function

     function QComboBox.GetPropertyInfo(n as string) as PELPropInfo
         return Base.GetPropertyInfo(n)
     end function

     function QComboBox.GetProperty(n as string) as zstring ptr
         return Base.GetProperty(n)
     end function

     function QComboBox.SetProperty(n as string,v as zstring ptr) as boolean
         return Base.SetProperty(n,v)
     end function
#endif

sub QComboBox.Handler(byref m as QMessage)
    Base.Handler(m)
end sub

sub QComboBox.Dispatch(byref m as QMessage)
    base.Dispatch(m)
end sub

function QComboBox.DlgProc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
    dim as PFrame F=iif(creationdata,creationdata,cast(PFrame,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-4)))
    dim as QMessage m=type(dlg,msg,wparam,lparam,0,F)
    if F then
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    else
       F=new QComboBox
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    end if
    return m.result
end function

function QComboBox.Register(v as string="QComboBox") as integer
    dim as wndclassex wcls
    wcls.cbsize=sizeof(wcls)
    if getclassinfoex(0,"combobox",@wcls) then
       wcls.cbwndextra+=sizeof(integer)
       wcls.lpfnwndproc=@dlgproc
       wcls.lpszclassname=strptr(v)
       wcls.hinstance=instance
       return RegisterClassEx(@wcls)
    end if
    return 0
end function

operator QComboBox.cast as any ptr
    return @this
end operator

operator QComboBox.cast as string
    return iif(classname<>"",classname,"QComboBox")
end operator

constructor QComboBox
    classname="QComboBox"
    classAncestor="combobox"
    fstyle=ws_child
    fwidth=121
    fheight=21
end constructor

destructor QComboBox
end destructor

/'QListBox'/
#ifdef rtl
     function QListBox.GetProperties as zstring ptr
         dim as string s=*Base.GetProperties
         dim as zstring ptr zs=callocate(len(s))
         *zs=s
         return zs
     end function

     function QListBox.GetPropertyInfo(n as string) as PELPropInfo
         return Base.GetPropertyInfo(n)
     end function

     function QListBox.GetProperty(n as string) as zstring ptr
         return Base.GetProperty(n)
     end function

     function QListBox.SetProperty(n as string,v as zstring ptr) as boolean
         return Base.SetProperty(n,v)
     end function
#endif

sub QListBox.Handler(byref m as QMessage)
    Base.Handler(m)
end sub

sub QListBox.Dispatch(byref m as QMessage)
    base.Dispatch(m)
end sub

function QListBox.DlgProc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
    dim as PFrame F=iif(creationdata,creationdata,cast(PFrame,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-4)))
    dim as QMessage m=type(dlg,msg,wparam,lparam,0,F)
    if F then
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    else
       F=new QListBox
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    end if
    return m.result
end function

function QListBox.Register(v as string="QListBox") as integer
    dim as wndclassex wcls
    wcls.cbsize=sizeof(wcls)
    if getclassinfoex(0,"listbox",@wcls) then
       wcls.cbwndextra+=sizeof(integer)
       wcls.lpfnwndproc=@dlgproc
       wcls.lpszclassname=strptr(v)
       wcls.hinstance=instance
       return RegisterClassEx(@wcls)
    end if
    return 0
end function

operator QListBox.cast as any ptr
    return @this
end operator

operator QListBox.cast as string
    return iif(classname<>"",classname,"QListBox")
end operator

constructor QListBox
    classname="QListBox"
    classAncestor="listbox"
    fstyle=ws_child
    fwidth=121
    fheight=121
end constructor

destructor QListBox
end destructor

/'QScrollBar'/
#ifdef rtl
     function QScrollBar.GetProperties as zstring ptr
         dim as string s=*Base.GetProperties
         dim as zstring ptr zs=callocate(len(s))
         *zs=s
         return zs
     end function

     function QScrollBar.GetPropertyInfo(n as string) as PELPropInfo
         return Base.GetPropertyInfo(n)
     end function

     function QScrollBar.GetProperty(n as string) as zstring ptr
         return Base.GetProperty(n)
     end function

     function QScrollBar.SetProperty(n as string,v as zstring ptr) as boolean
         return Base.SetProperty(n,v)
     end function
#endif

sub QScrollBar.Handler(byref m as QMessage)
    Base.Handler(m)
end sub

sub QScrollBar.Dispatch(byref m as QMessage)
    base.Dispatch(m)
end sub

function QScrollBar.DlgProc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
    dim as PFrame F=iif(creationdata,creationdata,cast(PFrame,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-4)))
    dim as QMessage m=type(dlg,msg,wparam,lparam,0,F)
    if F then
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    else
       F=new QScrollBar
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    end if
    return m.result
end function

function QScrollBar.Register(v as string="QScrollBar") as integer
    dim as wndclassex wcls
    wcls.cbsize=sizeof(wcls)
    if getclassinfoex(0,"scrollbar",@wcls) then
       wcls.cbwndextra+=sizeof(integer)
       wcls.lpfnwndproc=@dlgproc
       wcls.lpszclassname=strptr(v)
       wcls.hinstance=instance
       return RegisterClassEx(@wcls)
    end if
    return 0
end function

operator QScrollBar.cast as any ptr
    return @this
end operator

operator QScrollBar.cast as string
    return iif(classname<>"",classname,"QScrollBar")
end operator

constructor QScrollBar
    classname="QScrollBar"
    classAncestor="scrollbar"
    fstyle=ws_child
    fwidth=221
    fheight=17
end constructor

destructor QScrollBar
end destructor

sub standards_initialization constructor
     QStatic.register
     QButton.register
     QEdit.register
     QComboBox.register
     QListBox.register
     QScrollBar.register
end sub

sub standard_finalization destructor
    unregisterclass("QStatic",instance)
    unregisterclass("QButton",instance)
    unregisterclass("QEdit",instance)
    unregisterclass("QComboBox",instance)
    unregisterclass("QListBox",instance)
    unregisterclass("QScrollBar",instance)
end sub