/**
 * @file clean.h
 * @define internal cancel related interface
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __CLEAN_H__
#define __CLEAN_H__

#ifdef __cplusplus
extern "C" {
#endif

/* removes the most recently installed cleanup handler
 * and execute the handler
 */
int __pthread_destory_all_cleanup(void* __desr);

/* installs the routine function with argument arg as a cleanup handler */
void _pthread_cleanup_push(void (*routine) (void *), void *arg);

/* removes the most recently installed cleanup handler */
void _pthread_cleanup_pop(int execute);

#ifdef __cplusplus
}
#endif

#endif
