/*
 * Copyright (c) 2008, AIST.
 * All rights reserved. This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * National Institute of Advanced Industrial Science and Technology (AIST)
 */
/* $Id: server.c,v 1.2 2008/03/13 07:08:53 yoshi Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/select.h>
#include "shmc.h"

static Shmc *s_h = NULL;

static void sig_quit(int signum)
{
	shmcClose(s_h);
	exit(0);
}

int main()
{
	char buf[128];
	struct sigaction sa;
	
	memset(&sa, 0x00, sizeof(sa));
	sa.sa_handler = sig_quit;
	sa.sa_flags = SA_RESTART;

	if (sigaction(SIGINT, &sa, NULL) < 0) {
		perror("sigaction");
		return 1;
	}
	
        s_h = shmcOpen("foo.key", 'R');
	if (!s_h) {
		fprintf(stderr, "cannot open shcm\n");
		return 1;
	}

	if (shmcBind(s_h) < 0) {
		fprintf(stderr, "cannot bind shcm\n");
		goto err;
	}

	while (1) {
		struct timeval tv;
		tv.tv_sec = 5;
		tv.tv_usec = 0;
		select(1, NULL, NULL, NULL, &tv);
		int rbytes = shmcRecv(s_h, buf, sizeof(buf));
		if (rbytes < 0) {
			fprintf(stderr, "read error\n");
			goto err;
		} else if (rbytes > 0) {
			fprintf(stderr, "%d byts read\n", rbytes);
			printf("%s\n", buf);
		} else {
			//			fprintf(stderr, "not ready\n");
		}
	}

	return 0;
 err:
	shmcClose(s_h);
	return 1;
}
