/*
 * Copyright (c) 2008, AIST.
 * All rights reserved. This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * National Institute of Advanced Industrial Science and Technology (AIST)
 */
#include <stdio.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <string.h>

int main(int argc, char **argv)
{
	key_t key;
	key = ftok("foo.key", 'R');
	if (key == -1) {
		perror("ftok");
		return 1;
	}
	int id = shmget(key, 0, 0666);
	if (id == -1) {
		perror("shmget");
		return 1;
	}
	struct shmid_ds ds;
	if (shmctl(id, IPC_STAT, &ds) == -1) {
		perror("shmctl");
	} else {
		printf("size = %d\n", ds.shm_segsz);
	}
	char *adr = shmat(id, 0, 0);
	if (adr == (void *) -1) {
		perror("shmat");
		return 1;
	}

	char buf[128];
	int cnt = 0;
	while (1) {
		sprintf(buf, "%d", cnt);
		strcpy(adr, buf);
		//sleep(5);
		cnt++;
	}

	shmdt(adr);

	return 0;
}
