// -*- C++ -*-
/*!
 * @file  SamplePoint2DOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "SamplePoint2DOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* samplepoint2dout_spec[] =
  {
    "implementation_id", "SamplePoint2DOut",
    "type_name",         "SamplePoint2DOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

SamplePoint2DOut::SamplePoint2DOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_Point2DOut("Point2D", m_Point2D)

    // </rtc-template>
{
}

SamplePoint2DOut::~SamplePoint2DOut()
{
}


RTC::ReturnCode_t SamplePoint2DOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("Point2D", m_Point2DOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t SamplePoint2DOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SamplePoint2DOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SamplePoint2DOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SamplePoint2DOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SamplePoint2DOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t SamplePoint2DOut::onExecute(RTC::UniqueId ec_id)
{
  // Point2D
  m_Point2D.data.x = 10.5;
  m_Point2D.data.y = 12.7;
#ifndef __T_KERNEL__  
  m_Point2DOut.write();
#endif
  std::cout << "TimedPoint2D write" << std::endl;
  std::cout << "X:" << m_Point2D.data.x << std::endl;
  std::cout << "Y:" << m_Point2D.data.y << std::endl;
  std::cout << std::endl;
#ifdef __T_KERNEL__  
  m_Point2DOut.write();
  sleep(5);
#endif
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t SamplePoint2DOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SamplePoint2DOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SamplePoint2DOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SamplePoint2DOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SamplePoint2DOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void SamplePoint2DOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(samplepoint2dout_spec);
    manager->registerFactory(profile,
                             RTC::Create<SamplePoint2DOut>,
                             RTC::Delete<SamplePoint2DOut>);
  }
  
};



