// -*- C++ -*-
/*!
 * @file  RangerConfigOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "RangerConfigOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* rangerconfigout_spec[] =
  {
    "implementation_id", "RangerConfigOut",
    "type_name",         "RangerConfigOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

RangerConfigOut::RangerConfigOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_RConfigOut("RConfig", m_RConfig)

    // </rtc-template>
{
}

RangerConfigOut::~RangerConfigOut()
{
}


RTC::ReturnCode_t RangerConfigOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("RConfig", m_RConfigOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t RangerConfigOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerConfigOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerConfigOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerConfigOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerConfigOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t RangerConfigOut::onExecute(RTC::UniqueId ec_id)
{
  m_RConfig.minAngle = 10.1;
  m_RConfig.maxAngle = 20.2;
  m_RConfig.angularRes = 30.3;
  m_RConfig.minRange = 40.4;
  m_RConfig.maxRange = 50.5;
  m_RConfig.rangeRes = 60.6;
  m_RConfig.frequency = 70.7;

  std::cout << "RangerConfig Write" << std::endl;
  std::cout << "  minAngle:" << m_RConfig.minAngle << std::endl;
  std::cout << "  maxAngle:" << m_RConfig.maxAngle << std::endl;
  std::cout << "  angularRes:" << m_RConfig.angularRes << std::endl;
  std::cout << "  minRange:" << m_RConfig.minRange << std::endl;
  std::cout << "  maxRange:" << m_RConfig.maxRange << std::endl;
  std::cout << "  rangeRes:" << m_RConfig.rangeRes << std::endl;
  std::cout << "  frequency:" << m_RConfig.frequency << std::endl;

  m_RConfigOut.write();
  sleep(5);

  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t RangerConfigOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerConfigOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerConfigOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerConfigOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerConfigOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void RangerConfigOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(rangerconfigout_spec);
    manager->registerFactory(profile,
                             RTC::Create<RangerConfigOut>,
                             RTC::Delete<RangerConfigOut>);
  }
  
};



