class QSO
  attr_writer :callsign, :daytime, :qso_freq, :qso_mode, :rst_sent, :rst_rcvd
  attr_reader :callsign, :daytime, :qso_freq, :qso_mode, :rst_sent, :rst_rcvd

#  @@my_callsign = "JL3OXR"
  if ENV['QSO_MY_CALLSIGN']
    @@my_callsign=ENV['QSO_MY_CALLSIGN']
  else
    @@my_callsign="NOCALL"
  end

  def initialize
    @callsign = ""
    @daytime = Time.at(0)
    @qso_freq = 0.0
    @qso_mode = ""
    @rst_sent = ""
    @rst_rcvd = ""
    @qso_misc = Hash.new
  end
#  def qso_misc
#    @qso_misc
#  end
#  def qso_misc=(new_value)
#    @qso_misc = new_value
#  end
  attr("qso_misc", true)

# Define null methods
  def write_header
  end
  def write_footer
  end
  def read_header
  end
  def read_footer
  end

  def freq_range
    case @qso_freq
      when 0.136 .. 0.137 then 0.136 # in JA, 0.1357 - 0.1378
      when 0.501 .. 0.504 then 0.5 # in JA, not assigned.
      when 1.8 .. 2.0 then 1.8 # in JA, 1.810 - 1.825 and 1.9075 - 1.9125
      when 3.5 .. 4.0 then 3.5 # in JA, several sections between 3.50 and 3.805.
      when 5.102 .. 5.404 then 5.3 # in JA, not assigned.
      when 7.0 .. 7.3 then 7.0  # in JA, 7.0 - 7.2
      when 10.0 .. 10.15 then 10.1 # in JA, 10.1 - 10.15
      when 14.0 .. 14.35 then 14.0
      when 18.068 .. 18.168 then 18.1
      when 21.0 .. 21.45  then 21.0
      when 24.89 .. 24.99 then 24.9
      when 28.0 .. 29.7 then 28.0
      when 50.0 .. 54.0 then 50.0
      when 70.0 .. 71.0 then 71.0       # in JA, not assigned.
      when 144.0 .. 148.0 then 144.0    # in JA, 144.0 - 146.0
      when 222.0 .. 225.0 then 222.0    # in JA, not assigned.
      when 420.0 .. 450.0 then 430.0    # in JA, 430.0 - 440.0
      when 902.0 .. 928.0 then 902.0    # in JA, not assigned.
      when 1240.0 .. 1300.0 then 1260.0 # in JA, 1260.0 - 1300.0
      when 2300.0 .. 2450.0 then 2400.0 # in JA, 2400.0 - 2450.0
      when 3300.0 .. 3500.0 then 3300.0 # in JA, not assigned.
      when 5650.0 .. 5925.0 then 5650.0 # in JA, 5650.0 - 5850.0
      when 10000.0 .. 10500.0 then 10000.0
                            # in JA, 10000.0 - 10250.0 and 10450.0 - 10500.0
      when 24000.0 .. 24250.0 then 24000.0 # in JA, 24000.0 - 24050.0
      when 47000.0 .. 47200.0 then 47000.0 # in JA, 47000.0 - 47200.0
      when 75500.0 .. 81000.0 then 75000.0 # in JA, 77500.0 - 78000.0
      when 119980.0 .. 120020.0 then 120000.0 # in JA, not assigned?
      when 142000.0 .. 149000.0 then 142000.0 # in JA, not assigned?
      when 165000.0 .. 170000.0 then 165000.0 # Is this Reg. 2 only ?? 
      when 241000.0 .. 250000.0 then 240000.0 # in JA, 248000.0 - 250000.0
      when 300000.0 .. 300000.1 then 300000.0
# This band is supported in Cabrillo format, but no info is available.
# Could someone let me know?
      else raise "Freq. range?? #{@qso_freq}"
    end
  end
###################################################
# A simple example is given below.
#
# require "qso"
#
# zlog = ZlogDos.new
# adif = Adif.new
#
# zlog.read_header
# adif.write_header
# until $<.eof?
#   zlog.read_a_record
#
#   QSO::convert(zlog, adif)
#   adif.write
#  end
##################################################
#
#  def read
#    read_header
#    read_a_record until eof?
#    read_footer
#  end returns an array object.
#
#  def read_a_record
#    readline
#    parse
#  end returns single object?
#

  def QSO.convert(src, dest)
    dest.callsign = src.callsign
     dest.daytime = src.daytime
    dest.qso_freq = src.qso_freq
    dest.qso_mode = src.qso_mode
    dest.rst_sent = src.rst_sent
#     dest.nr_sent = src.nr_sent
    dest.rst_rcvd = src.rst_rcvd
#     dest.nr_rcvd = src.nr_rcvd
#    dest.qso_misc['stx'] = src.qso_misc['stx'] if src.qso_misc.key?('stx')
#    dest.qso_misc['srx'] = src.qso_misc['srx'] if src.qso_misc.key?('srx')
    dest.qso_misc = src.qso_misc
  end

  def self=(src)
    self.callsign = src.callsign
    self.daytime  = src.daytime
    self.qso_freq = src.qso_freq
    self.qso_mode = src.qso_mode
    self.rst_sent = src.rst_sent
    self.rst_rcvd = src.rst_rcvd
    self.qso_misc = src.qso_misc
  end
end

class Adif < QSO
  def initialize
    super
    @adif_field = Hash.new
    @adif_opt_type = Hash.new
    @band = {
      '2190m' => 0.136,   '560m' => 0.5,    '160m' => 1.8,
      '80m' => 3.5,       '60m' => 5.3,     '40m' => 7.0,
      '30m' => 10.1,      '20m' => 14.0,      '17m' => 18.1,
      '15m' => 21.0,      '12m' => 24.9,      '10m' => 28.0,
      '6m' => 50.0,       '4m' => 71.0,
      '2m' => 144.0,      '1.25m' => 222.0,
      '70cm' => 430.0,      '33cm' => 902.0,      '23cm' => 1260.0,
      '13cm' => 2400.0,      '9cm' => 3300.0,      '6cm' => 5650.0,
      '3cm' => 10000.0,      '1.25cm' => 24000.0,      '6mm' => 47000.0,
      '4mm' => 75000.0,      '2.5mm' => 120000.0,      '2mm' => 142000.0,
      '1mm' => 240000.0
    }
  end ### End method #initialize

  def write
    print "<call:#{@callsign.length}>#{@callsign}"
    print "<qso_date:8>#{@daytime.utc.strftime("%Y%m%d")}"
    print "<time_on:6>#{@daytime.utc.strftime("%H%M%S")}"
    temp = @band.index(freq_range)
    if temp == nil
      raise "Unsupported band is set."
    end
    print "<band:#{temp.length}>#{temp}"
    print "<mode:#{@qso_mode.length}>#{@qso_mode}"
    print "<rst_sent:#{@rst_sent.length}>#{@rst_sent}"
    print "<rst_rcvd:#{@rst_rcvd.length}>#{@rst_rcvd}"

    write_adif_element('address')
    write_adif_element('age')
    write_adif_element('arrl_sect') # characters.
    write_adif_element('cnty')
    # cnty holds the secondary administrative subdivision in ver 2.1.6
    write_adif_element('comment')
    write_adif_element('cont')
    write_adif_element('contest_id')
    write_adif_element('cqz')
    write_adif_element('dxcc')
    write_adif_element('freq') # How does this reconcile with 'band'?
    write_adif_element('gridsquare')

    write_adif_element('iota')
    write_adif_element('ituz')
    write_adif_element('name')
    write_adif_element('notes')
    write_adif_element('pfx')
    write_adif_element('prop_mode')
    write_adif_element('qslmsg')
    write_adif_element('qslrdate')
    write_adif_element('qslsdate')
    write_adif_element('qsl_rcvd')
    write_adif_element('qsl_sent')
    write_adif_element('qsl_via')
    write_adif_element('rx_pwr')
    write_adif_element('sat_mode')
    write_adif_element('sat_name')
    write_adif_element('srx')
    write_adif_element('state')
    write_adif_element('stx')
    write_adif_element('ten_ten')
    write_adif_element('time_off')
    write_adif_element('tx_pwr')

    if ENV['QSO_ADIF1_STRICT']
      write_adif_element('ve_prov') # deprecated; use state instead. ver. 1
    else
      write_adif_element('a_index') # ver. 2.2.2
      write_adif_element('ant_az') # ver. 2.1.6
      write_adif_element('ant_el') # ver. 2.1.6
      write_adif_element('ant_path') # ver. 2.2.2
      write_adif_element('band_rx') # ver. 2.1.6
      write_adif_element('check') # ver. 2.2.2
      write_adif_element('class') # ver. 2.2.2
      write_adif_element('contacted_op') # ver. 2.2.2
      write_adif_element('country') # ver. 2.2.2
      write_adif_element('credit_submitted') # ver. 2.2.3
      write_adif_element('credit_granted') # ver. 2.2.3
      write_adif_element('distance') # ver. 2.2.2
      write_adif_element('email') # ver. 2.2.2
      write_adif_element('eq_call') # ver. 2.1.6
      write_adif_element('eqsl_qslrdate') # ver. 2.2.2
      write_adif_element('eqsl_qslsdate') # ver. 2.2.2
      write_adif_element('eqsl_qsl_rcvd') # ver. 2.2.2
      write_adif_element('eqsl_qsl_sent') # ver. 2.2.2
      write_adif_element('force_init') # ver. 2.2.2
      write_adif_element('freq_rx') # ver. 2.1.6
      write_adif_element('guest_op')
      # deprecated. use operator instead. ver 2.1.6
      write_adif_element('iota_island_id') # ver. 2.2.3
      write_adif_element('k_index') # ver. 2.2.2
      write_adif_element('lat') # ver. 2.1.6
      write_adif_element('lon') # ver. 2.1.6
      write_adif_element('lotw_qslrdate') # ver. 2.2.2
      write_adif_element('lotw_qslsdate') # ver. 2.2.2
      write_adif_element('lotw_qsl_rcvd') # ver. 2.2.2
      write_adif_element('lotw_qsl_sent') # ver. 2.2.2
      write_adif_element('max_bursts') # ver. 2.1.6
      write_adif_element('ms_shower') # ver. 2.1.6
      write_adif_element('my_city') # ver. 2.1.1
      write_adif_element('my_cnty') # ver. 2.1.6
      write_adif_element('my_country') # ver. 2.1.6
      write_adif_element('my_cq_zone') # ver. 2.1.1
      write_adif_element('my_gridsquare') # ver. 2.1.6
      write_adif_element('my_iota') # ver. 2.1.6
      write_adif_element('my_iota_island_id') # ver. 2.2.3
      write_adif_element('my_itu_zone') # ver. 2.1.1
      write_adif_element('my_lat') # ver. 2.1.6
      write_adif_element('my_lon') # ver. 2.1.6
      write_adif_element('my_name') # ver. 2.1.6
      write_adif_element('my_postal_code') # ver. 2.1.1
      write_adif_element('my_rig') # ver. 2.1.2
      write_adif_element('my_sig') # ver. 2.1.6
      write_adif_element('my_sig_info') # ver. 2.1.6
      write_adif_element('my_state') # ver. 2.1.6
      write_adif_element('my_street') # ver. 2.1.1
      write_adif_element('nr_bursts') # ver. 2.1.6
      write_adif_element('nr_pings') # ver. 2.1.6
      write_adif_element('operator') # ver. 2.1.6
      # If station_callsign is absent, operator shall be treated as both
      # the logging station's callsign and the logging operator's callsign.
      write_adif_element('owner_callsign') # ver. 2.1.6
      # If owner_callsign is absent, station_callsign shall be treated as both
      # the logging station's callsign and the callsign of the owner of the station.
      write_adif_element('precedence') # ver. 2.2.2
      write_adif_element('public_key') # ver. 2.1.6
      write_adif_element('qsl_rcvd_via') # ver. 2.1.6
      write_adif_element('qsl_sent_via') # ver. 2.1.6
      write_adif_element('qso_complete') # ver. 2.1.6
      write_adif_element('qso_date_off') # ver. 2.2.3
      write_adif_element('qso_random') # ver. 2.1.6
      write_adif_element('qth') # ver. 2.1.6
      write_adif_element('rig') # ver. 2.1.6
      write_adif_element('sfi') # ver. 2.2.2
      write_adif_element('sig') # ver. 2.1.6
      write_adif_element('sig_info') # ver. 2.1.6
      write_adif_element('srx_string') # ver. 2.1.6
      write_adif_element('station_callsign') # ver. 2.1.6
      write_adif_element('stx_string') # ver. 2.1.6
      write_adif_element('swl') # ver. 2.1.6
      write_adif_element('web') # ver. 2.2.2
    end

    print "<eor>\n"
  end ### End method #write

  def write_adif_element(val)
    if @qso_misc.key?(val)
      print "<#{val}:#{@qso_misc[val].length}>#{@qso_misc[val]}"
    end
  end

  def parse
    record = $<.readline("<eor>")
    record.delete!("\n")

    record.gsub!(/</, "\n").each do |each_field|
      each_field.chop!
      next if each_field.empty?
      break if each_field == "eor"
      field_tag, field_data = each_field.split(">")
      field_name, field_size, field_type = field_tag.split(":")
      unless field_type.nil?
        @adif_opt_type[field_name.downcase] = field_type.downcase
      end
      @adif_field[field_name.downcase] = field_data[0, field_size.to_i]
    end ### End do |each_field|
  end ### End method parse

  def read_a_record
    parse
    @callsign = @adif_field['call'].upcase
    temp_date = @adif_field['qso_date']
    temp_time = @adif_field['time_on']
    @daytime = Time.utc(temp_date[0..3], temp_date[4..5], temp_date[6..7], \
      temp_time[0..1], temp_time[2..3])
    @daytime += temp_time[4..5].to_i if temp_time.length == 6
    @qso_freq = @band["#{@adif_field['band'].downcase}"]
    @qso_mode = @adif_field['mode'].upcase
    @rst_sent = @adif_field['rst_sent']
    @rst_rcvd = @adif_field['rst_rcvd']
    @qso_misc['stx'] = @adif_field['stx']
    @qso_misc['srx'] = @adif_field['srx']
  end ### End method #read_a_record
end ### End class Adif

class Cabrillo < QSO
  def initialize
    super
    @band = {
      '50' => 50.0,
      '144' => 144.0,
      '222' => 222.0,
      '432' => 430.0,
      '902' => 902.0,
      '1.2' => 1260.0,
      '2.3' => 2400.0,
      '3.4' => 3300.0,
      '5.7' => 5650.0,
      '10' => 10000.0,
      '24' => 24000.0,
      '47' => 47000.0,
      '75' => 75000.0,
      '119' => 120000.0,
      '142' => 142000.0,
      '241' => 240000.0, 
      '300' => 300000.0
# LIGHT is not supported at this stage.
    }
  end
  def write
    print "QSO: "
    if @qso_freq < 30.0
      printf("%5d ", @qso_freq * 1000)
    else
      temp = @band.index(freq_range)
      raise "Unsupported band is set." if temp == nil
      printf("%5s ", temp)
    end

    if (@qso_mode == "CW") || (@qso_mode == "FM" )
      printf("%2s ", @qso_mode)
    elsif @qso_mode == "RTTY"
      print "RY "
    else
      print "PH "  # Even though not really adequate....
    end
    printf("%10s ", @daytime.utc.strftime("%Y-%m-%d"))
    printf("%4s ", @daytime.utc.strftime("%H%M"))
    printf("%-13s ", @@my_callsign)
    printf("%-3s ", @rst_sent)
    printf("%6s ", @qso_misc['stx'])
    printf("%-13s ", @callsign)
    printf("%-3s ", @rst_rcvd)
    printf("%6s ", @qso_misc['srx'])
    printf("1\n")
  end
end

class ZlogDos < QSO
  def initialize
    super
    @band = {
      '1.9' => 1.8,
      '3.5' => 3.5,
      '7' => 7.0,
      '14' => 14.0,
      '21' => 21.0,
      '28' => 28.0,
      '50' => 50.0,
      '144' => 144.0,
      '430' => 430.0,
      '1200' => 1260.0,
      '2400' => 2400.0,
      '5600' => 5650.0,
      '10G' => 10000.0
    }

    if ENV['QSO_ZLOG_YEAR']
      if ENV['QSO_ZLOG_YEAR'] =~ /^[0-9]{4}$/
        @zlog_year = ENV['QSO_ZLOG_YEAR']
      else
        raise "Invalid QSO_ZLOG_YEAR: #{ENV['QSO_ZLOG_YEAR']}"
      end
    else
      @zlog_year = Time.now.strftime("%Y")
    end
  end
  def write_header
    print "mon day time  callsign      sent\
         rcvd      multi   MHz mode pts memo\r\n"
  end
  def write
    jst_time = @daytime.utc + 9 * 60 * 60
# Time zone is fixed to JST, since this format is used only inside of JA.
    printf(" %2d ", jst_time.mon)
    printf(" %2d ", jst_time.day)
    printf("%02d%02d ", jst_time.hour, jst_time.min)
    printf("%-10s", @callsign)
    printf(" %3s", @rst_sent)
    printf("%-8s ", @qso_misc['stx'])
    printf(" %3s", @rst_rcvd)
    printf("%-8s ", @qso_misc['srx'])
    printf("        ") # if multi?
# The column for MULTI is doing nothing. This might be supported.
# But think. Such stuff should be done by logging tools, shouldn't it?
    temp = @band.index(freq_range)
    if temp == nil
      raise "Unsupported band is set."
    end
    printf(" %4s ", temp ) 
    printf(" %-3s ", @qso_mode)
    printf("1  \r\n")
  end
  def read_header
    $<.readline
  end
  def read_a_record
    record = $<.readline.chomp

    jst_time = Time.utc(@zlog_year, record[1..2].to_i, record[5..6].to_i,\
      record[8..9].to_i, record[10..11].to_i)
    @daytime = jst_time - 9 * 60 * 60
    @callsign = record[13..22].strip
    @rst_sent = record[24..26].strip
    temp = record[27..34].strip
    @qso_misc['stx'] = temp unless temp.empty?
    @rst_rcvd = record[37..39].strip
    temp = record[40..47].strip
    @qso_misc['srx'] = temp unless temp.empty?
    temp = record[58..61].strip
    @qso_freq = @band[temp]
    @qso_mode = record[64..66].strip
  end
end

class ZlogWin < QSO
  def initialize
    super
    @band = {
      '1.9' => 1.8,
      '3.5' => 3.5,
      '7' => 7.0,
      '10' => 10.1,
      '14' => 14.0,
      '18' => 18.1,
      '21' => 21.0,
      '24' => 24.9,
      '28' => 28.0,
      '50' => 50.0,
      '144' => 144.0,
      '430' => 430.0,
      '1200' => 1260.0,
      '2400' => 2400.0,
      '5600' => 5650.0,
      '10G' => 10000.0
    }

  end
  def write_header
    print "zLog for Windows \r\n"
  end
  def write
    jst_time = @daytime.utc + 9 * 60 * 60
# Time zone is fixed to JST, since this format is used only inside of JA.
    printf("%04d/%02d/%02d ", jst_time.year, jst_time.mon, jst_time.day)
    printf("%02d:%02d ", jst_time.hour, jst_time.min)
    printf("%-12s ", @callsign)
    printf("%-3s ", @rst_sent)
    printf("%-7s ", @qso_misc['stx'])
    printf("%-3s ", @rst_rcvd)
    printf("%-7s ", @qso_misc['srx'])
    printf("-     -     ") # if multi?
# The column for MULTI is doing nothing. This might be supported.
# But think. Such stuff should be done by logging tools, shouldn't it?
    temp = @band.index(freq_range)
    if temp == nil
      raise "Unsupported band is set."
    end
    printf("%-4s ", temp )
    unless [ "SSB", "CW", "AM", "FM", "RTTY" ].include?(@qso_mode)
      @qso_mode = "Other"
    end
    printf("%-5s", @qso_mode)
    printf("1  \r\n")
  end
  def read_header
    $<.readline
  end
  def read_a_record
    record = $<.readline.chomp

    jst_time = Time.utc(record[0..3].to_i, record[5..6].to_i,\
      record[8..9].to_i, record[11..12].to_i, record[14..15].to_i)
    @daytime = jst_time - 9 * 60 * 60
    @callsign = record[17..28].strip
    @rst_sent = record[30..32].strip
    temp = record[34..40].strip
    @qso_misc['stx'] = temp unless temp.empty?
    @rst_rcvd = record[42..44].strip
    temp = record[46..52].strip
    @qso_misc['srx'] = temp unless temp.empty?
    temp = record[66..69].strip
    @qso_freq = @band[temp]
    @qso_mode = record[71..74].strip
    @qso_mode = "PSK31" if @qso_mode == "Other" # Cast to any.
  end
end

class HamLog < QSO
  def initialize
  end

  def write
    jst_time = @daytime.utc + 9 * 60 * 60
    # Time zone is now fixed to JST, since this format is mainly used in JA.
    printf("%s,", @callsign)
    printf("%04d/%02d/%02d,", jst_time.year, jst_time.mon, jst_time.day)
    # It seems that Hamlog supports Japanese year notation as well.
    # But it would be nice to use Christian year in order to reduce the
    # code length, wouldn't it?
    printf("%02d:%02dJ,", jst_time.hour, jst_time.min)
    printf("%s,%s,", @rst_sent, @rst_rcvd)
    printf("%d,", @qso_freq.to_i)
    printf("%s,", @qso_mode)
    # I'm not sure if there is a mode designated in letters longer than 4.
    printf(",") # FIX ME. JCC/JCG, Country code for DX stations.
    printf("%s,", @qso_misc['gridsquare'])
    printf("J,")     # write J, ha ha.
    printf(",") # OP name
    printf(",") # QTH
    printf(",") # remarks 1
    printf(",") # remarks 2
    printf("0\r\n") # always 0?
  end

  def read_a_record
    record = $<.readline.chomp.split(/,/)
    @callsign = record[0]
    # Process year.
    if record[1].index(".")
      year, month, day = record[1].split(/\./)
      case year[0, 1]
      when 'H'
        cyear = year[1..2].to_i + 1988
      when 'S'
        cyear = year[1..2].to_i + 1925
      else
        raise "Unknown Japanese year."
      end
    else
      year, month, day = record[1].split(/\//)
      cyear = year.to_i
      if cyear < 100
        if cyear > 45
          cyear += 1900
        else
          cyear += 2000 # Yes. You'll encounter the year 2045 problem.
        end
      end
    end # End of process year.
    @daytime = Time.utc(cyear, month.to_i, day.to_i, record[2][0..1].to_i, record[2][3..4].to_i)
    @daytime -= 9 * 60 * 60 unless record[2][5,1] == 'U'
    @rst_sent = record[3]
    @rst_rcvd = record[4]
    @qso_freq = record[5]
    temp = freq_range.to_i
    print @daytime.ctime

  end
end
