// $Id: RxKernel.cpp,v 1.2 2002/10/21 14:17:39 yuya Exp $

#include "rubyxx/RxKernel.h"

////////////////////////////////////////////////////////////////////////////////

RxKernel::RxKernel()
{
}

RxKernel::~RxKernel()
{
}

////////////////////////////////////////////////////////////////////////////////

RxClass
RxKernel::meta()
{
	return RxClass(RxObject(rb_mKernel));
}

RxObject
RxKernel::abort()
{
	return meta().mcall("abort");
}

RxObject
RxKernel::ancestors()
{
	return meta().mcall("ancestors");
}

RxObject
RxKernel::at_exit()
{
	return meta().mcall("at_exit");
}

RxObject
RxKernel::autoload()
{
	return meta().mcall("autoload");
}

RxObject
RxKernel::binding()
{
	return meta().mcall("binding");
}

RxObject
RxKernel::block_given_()
{
	return meta().mcall("block_given?");
}

RxObject
RxKernel::callcc()
{
	return meta().mcall("callcc");
}

RxObject
RxKernel::caller()
{
	return meta().mcall("caller");
}

RxObject
RxKernel::catch_()
{
	return meta().mcall("catch");
}

RxObject
RxKernel::chomp()
{
	return meta().mcall("chomp");
}

RxObject
RxKernel::chomp_()
{
	return meta().mcall("chomp!");
}

RxObject
RxKernel::chop()
{
	return meta().mcall("chop");
}

RxObject
RxKernel::chop_()
{
	return meta().mcall("chop!");
}

RxObject
RxKernel::class_()
{
	return meta().mcall("class");
}

RxObject
RxKernel::class_eval()
{
	return meta().mcall("class_eval");
}

RxObject
RxKernel::class_variables()
{
	return meta().mcall("class_variables");
}

RxObject
RxKernel::clone()
{
	return meta().mcall("clone");
}

RxObject
RxKernel::const_defined_()
{
	return meta().mcall("const_defined?");
}

RxObject
RxKernel::const_get()
{
	return meta().mcall("const_get");
}

RxObject
RxKernel::const_set()
{
	return meta().mcall("const_set");
}

RxObject
RxKernel::constants()
{
	return meta().mcall("constants");
}

RxObject
RxKernel::display()
{
	return meta().mcall("display");
}

RxObject
RxKernel::dup_()
{
	return meta().mcall("dup");
}

RxObject
RxKernel::eql_()
{
	return meta().mcall("eql?");
}

RxObject
RxKernel::equal_()
{
	return meta().mcall("equal?");
}

RxObject
RxKernel::eval(RxString source, RxObject binding)
{
	if ( !binding.is_nil() ) {
		return meta().mcall("eval", source);
	} else {
		return meta().mcall("eval", source, binding);
	}
}

RxObject
RxKernel::exec()
{
	return meta().mcall("exec");
}

RxObject
RxKernel::exit()
{
	return meta().mcall("exit");
}

RxObject
RxKernel::exit_()
{
	return meta().mcall("exit!");
}

RxObject
RxKernel::extend()
{
	return meta().mcall("extend");
}

RxObject
RxKernel::fail()
{
	return meta().mcall("fail");
}

RxObject
RxKernel::fork()
{
	return meta().mcall("fork");
}

RxObject
RxKernel::format(RxString format, RxArray args)
{
	return meta().apply("format", format, args);
}

RxObject
RxKernel::freeze()
{
	return meta().mcall("freeze");
}

RxObject
RxKernel::frozen_()
{
	return meta().mcall("frozen?");
}

RxObject
RxKernel::getc_()
{
	return meta().mcall("getc");
}

RxObject
RxKernel::gets()
{
	return meta().mcall("gets");
}

RxObject
RxKernel::global_variables()
{
	return meta().mcall("global_variables");
}

RxObject
RxKernel::gsub()
{
	return meta().mcall("gsub");
}

RxObject
RxKernel::gsub_()
{
	return meta().mcall("gsub!");
}

RxObject
RxKernel::hash()
{
	return meta().mcall("hash");
}

RxObject
RxKernel::id()
{
	return meta().mcall("id");
}

RxObject
RxKernel::included_modules()
{
	return meta().mcall("included_modules");
}

RxObject
RxKernel::inspect()
{
	return meta().mcall("inspect");
}

RxObject
RxKernel::instance_eval()
{
	return meta().mcall("instance_eval");
}

RxObject
RxKernel::instance_method()
{
	return meta().mcall("instance_method");
}

RxObject
RxKernel::instance_methods()
{
	return meta().mcall("instance_methods");
}

RxObject
RxKernel::instance_of_()
{
	return meta().mcall("instance_of?");
}

RxObject
RxKernel::instance_variables()
{
	return meta().mcall("instance_variables");
}

RxObject
RxKernel::is_a_()
{
	return meta().mcall("is_a?");
}

RxObject
RxKernel::iterator_()
{
	return meta().mcall("iterator?");
}

RxObject
RxKernel::kind_of_()
{
	return meta().mcall("kind_of?");
}

RxObject
RxKernel::lambda()
{
	return meta().mcall("lambda");
}

RxObject
RxKernel::load()
{
	return meta().mcall("load");
}

RxObject
RxKernel::local_variables()
{
	return meta().mcall("local_variables");
}

RxObject
RxKernel::loop()
{
	return meta().mcall("loop");
}

RxObject
RxKernel::method()
{
	return meta().mcall("method");
}

RxObject
RxKernel::method_defined_()
{
	return meta().mcall("method_defined?");
}

RxObject
RxKernel::method_missing()
{
	return meta().mcall("method_missing");
}

RxObject
RxKernel::methods()
{
	return meta().mcall("methods");
}

RxObject
RxKernel::module_eval()
{
	return meta().mcall("module_eval");
}

RxObject
RxKernel::name()
{
	return meta().mcall("name");
}

RxObject
RxKernel::nil_()
{
	return meta().mcall("nil?");
}

RxObject
RxKernel::open()
{
	return meta().mcall("open");
}

RxObject
RxKernel::p()
{
	return meta().mcall("p");
}

RxObject
RxKernel::print()
{
	return meta().mcall("print");
}

RxObject
RxKernel::printf()
{
	return meta().mcall("printf");
}

RxObject
RxKernel::private_class_method()
{
	return meta().mcall("private_class_method");
}

RxObject
RxKernel::private_instance_methods()
{
	return meta().mcall("private_instance_methods");
}

RxObject
RxKernel::private_methods()
{
	return meta().mcall("private_methods");
}

RxObject
RxKernel::proc()
{
	return meta().mcall("proc");
}

RxObject
RxKernel::protected_instance_methods()
{
	return meta().mcall("protected_instance_methods");
}

RxObject
RxKernel::protected_methods()
{
	return meta().mcall("protected_methods");
}

RxObject
RxKernel::public_class_method()
{
	return meta().mcall("public_class_method");
}

RxObject
RxKernel::public_instance_methods()
{
	return meta().mcall("public_instance_methods");
}

RxObject
RxKernel::public_methods()
{
	return meta().mcall("public_methods");
}

RxObject
RxKernel::putc_()
{
	return meta().mcall("putc");
}

RxObject
RxKernel::puts()
{
	return meta().mcall("puts");
}

RxObject
RxKernel::raise()
{
	return meta().mcall("raise");
}

RxObject
RxKernel::rand()
{
	return meta().mcall("rand");
}

RxObject
RxKernel::readline()
{
	return meta().mcall("readline");
}

RxObject
RxKernel::readlines()
{
	return meta().mcall("readlines");
}

RxObject
RxKernel::require(RxString filename)
{
	return meta().mcall("require", filename);
}

RxObject
RxKernel::respond_to_()
{
	return meta().mcall("respond_to?");
}

RxObject
RxKernel::scan()
{
	return meta().mcall("scan");
}

RxObject
RxKernel::select()
{
	return meta().mcall("select");
}

RxObject
RxKernel::set_trace_func()
{
	return meta().mcall("set_trace_func");
}

RxObject
RxKernel::singleton_method_added()
{
	return meta().mcall("singleton_method_added");
}

RxObject
RxKernel::singleton_methods()
{
	return meta().mcall("singleton_methods");
}

RxObject
RxKernel::sleep_()
{
	return meta().mcall("sleep");
}

RxObject
RxKernel::split()
{
	return meta().mcall("split");
}

RxObject
RxKernel::sprintf()
{
	return meta().mcall("sprintf");
}

RxObject
RxKernel::srand()
{
	return meta().mcall("srand");
}

RxObject
RxKernel::sub()
{
	return meta().mcall("sub");
}

RxObject
RxKernel::sub_()
{
	return meta().mcall("sub!");
}

RxObject
RxKernel::syscall()
{
	return meta().mcall("syscall");
}

RxObject
RxKernel::system()
{
	return meta().mcall("system");
}

RxObject
RxKernel::taint()
{
	return meta().mcall("taint");
}

RxObject
RxKernel::tainted_()
{
	return meta().mcall("tainted?");
}

RxObject
RxKernel::test()
{
	return meta().mcall("test");
}

RxObject
RxKernel::throw_()
{
	return meta().mcall("throw");
}

RxObject
RxKernel::to_a()
{
	return meta().mcall("to_a");
}

RxObject
RxKernel::to_s()
{
	return meta().mcall("to_s");
}

RxObject
RxKernel::trace_var()
{
	return meta().mcall("trace_var");
}

RxObject
RxKernel::trap()
{
	return meta().mcall("trap");
}

RxObject
RxKernel::type()
{
	return meta().mcall("type");
}

RxObject
RxKernel::untaint()
{
	return meta().mcall("untaint");
}

RxObject
RxKernel::untrace_var()
{
	return meta().mcall("untrace_var");
}


RxIO
RxKernel::STDIN()
{
	return RxIO(RxObject::meta().get_const("STDIN"));
}

RxIO
RxKernel::STDOUT()
{
	return RxIO(RxObject::meta().get_const("STDOUT"));
}

RxIO
RxKernel::STDERR()
{
	return RxIO(RxObject::meta().get_const("STDERR"));
}

////////////////////////////////////////////////////////////////////////////////
