// $Id: RxTime.cpp,v 1.2 2002/10/21 14:17:39 yuya Exp $

#include "rubyxx/RxTime.h"

////////////////////////////////////////////////////////////////////////////////

RxTime::RxTime(time_t sec, time_t usec)
	: RxObject(::rb_time_new(sec, usec))
{
}

RxTime::RxTime(const RxObject& obj)
	: RxObject(obj)
{
}

RxTime::~RxTime()
{
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxTime::asctime() const
{
	return mcall("asctime");
}

RxObject
RxTime::ctime() const
{
	return mcall("ctime");
}

RxObject
RxTime::day() const
{
	return mcall("day");
}

RxObject
RxTime::dst_() const
{
	return mcall("dst?");
}

RxObject
RxTime::gmt_() const
{
	return mcall("gmt?");
}

RxObject
RxTime::gmt_offset() const
{
	return mcall("gmt_offset");
}

RxObject
RxTime::gmtime() const
{
	return mcall("gmtime");
}

RxObject
RxTime::gmtoff() const
{
	return mcall("gmtoff");
}

RxObject
RxTime::hour() const
{
	return mcall("hour");
}

RxObject
RxTime::isdst() const
{
	return mcall("isdst");
}

RxObject
RxTime::localtime() const
{
	return mcall("localtime");
}

RxObject
RxTime::mday() const
{
	return mcall("mday");
}

RxObject
RxTime::mon() const
{
	return mcall("mon");
}

RxObject
RxTime::month() const
{
	return mcall("month");
}

RxObject
RxTime::sec() const
{
	return mcall("sec");
}

RxObject
RxTime::strftime() const
{
	return mcall("strftime");
}

RxObject
RxTime::to_f() const
{
	return mcall("to_f");
}

RxObject
RxTime::to_i() const
{
	return mcall("to_i");
}

RxObject
RxTime::tv_sec() const
{
	return mcall("tv_sec");
}

RxObject
RxTime::tv_usec() const
{
	return mcall("tv_usec");
}

RxObject
RxTime::usec() const
{
	return mcall("usec");
}

RxObject
RxTime::utc() const
{
	return mcall("utc");
}

RxObject
RxTime::utc_() const
{
	return mcall("utc?");
}

RxObject
RxTime::utc_offset() const
{
	return mcall("utc_offset");
}

RxObject
RxTime::wday() const
{
	return mcall("wday");
}

RxObject
RxTime::yday() const
{
	return mcall("yday");
}

RxObject
RxTime::year() const
{
	return mcall("year");
}

RxObject
RxTime::zone() const
{
	return mcall("zone");
}

////////////////////////////////////////////////////////////////////////////////
