
#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <rubyxx/Rx.h>

USING_NAMESPACE_CPPUNIT

class TestRxNumeric : public TestCase
{
public:

	TestRxNumeric(const char* name) : TestCase(name) {}

	static Test* suite()
	{
		TestSuite* suite = new TestSuite("TestRxNumeric");

		suite->addTest(new TEST_CALLER(TestRxNumeric, test_is_nil));
		suite->addTest(new TEST_CALLER(TestRxNumeric, test_is_true));
		suite->addTest(new TEST_CALLER(TestRxNumeric, test_is_false));

		return suite;
	}

	virtual void setUp()
	{
		RxGC::start();
	}

	void test_is_nil()
	{
		TEST_ASSERT(RxNumeric().is_nil() == false);
	}

	void test_is_true()
	{
		TEST_ASSERT(RxNumeric().is_true() == false);
	}

	void test_is_false()
	{
		TEST_ASSERT(RxNumeric().is_false() == false);
	}

};
