
#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <rubyxx/Rx.h>

USING_NAMESPACE_CPPUNIT

class TestRxObject : public TestCase
{
public:

	TestRxObject(const char* name) : TestCase(name) {}

	static Test* suite()
	{
		TestSuite* suite = new TestSuite("TestRxObject");

		suite->addTest(new TEST_CALLER(TestRxObject, test_ope_bool));
		suite->addTest(new TEST_CALLER(TestRxObject, test_ope_eq));
		suite->addTest(new TEST_CALLER(TestRxObject, test_ope_neq));
		suite->addTest(new TEST_CALLER(TestRxObject, test_ope_ge));
		suite->addTest(new TEST_CALLER(TestRxObject, test_ope_geq));
		suite->addTest(new TEST_CALLER(TestRxObject, test_ope_le));
		suite->addTest(new TEST_CALLER(TestRxObject, test_ope_leq));

		suite->addTest(new TEST_CALLER(TestRxObject, test_value));
		suite->addTest(new TEST_CALLER(TestRxObject, test_is_nil));
		suite->addTest(new TEST_CALLER(TestRxObject, test_is_true));
		suite->addTest(new TEST_CALLER(TestRxObject, test_is_false));

		suite->addTest(new TEST_CALLER(TestRxObject, test_type));
		suite->addTest(new TEST_CALLER(TestRxObject, test_dup));
		suite->addTest(new TEST_CALLER(TestRxObject, test_id));
		suite->addTest(new TEST_CALLER(TestRxObject, test_inspect));
		suite->addTest(new TEST_CALLER(TestRxObject, test_is_a));
		suite->addTest(new TEST_CALLER(TestRxObject, test_kind_of));

		return suite;
	}

	virtual void setUp()
	{
		RxGC::start();
	}

	void test_ope_bool()
	{
		TEST_ASSERT((bool)RxNil() == false);
		TEST_ASSERT((bool)RxTrue() == true);
		TEST_ASSERT((bool)RxFalse() == false);
		TEST_ASSERT((bool)RxNumeric() == true);
		TEST_ASSERT((bool)RxString() == true);
	}

	void test_ope_eq()
	{
		TEST_ASSERT(RxObject(Qnil) == RxObject(Qnil));
		TEST_ASSERT(RxObject(Qtrue) == RxObject(Qtrue));
		TEST_ASSERT(RxObject(Qfalse) == RxObject(Qfalse));
	}

	void test_ope_neq()
	{
		TEST_ASSERT(RxObject(Qnil) != RxObject(Qtrue));
		TEST_ASSERT(RxObject(Qtrue) != RxObject(Qfalse));
		TEST_ASSERT(RxObject(Qfalse) != RxObject(Qnil));
	}

	void test_ope_ge()
	{
		TEST_ASSERT(RxObject(INT2FIX(0)) > RxObject(INT2FIX(0)) == false);
		TEST_ASSERT(RxObject(INT2FIX(1)) > RxObject(INT2FIX(0)) == true);
		TEST_ASSERT(RxObject(INT2FIX(0)) > RxObject(INT2FIX(1)) == false);
	}

	void test_ope_geq()
	{
		TEST_ASSERT(RxObject(INT2FIX(0)) >= RxObject(INT2FIX(0)) == true);
		TEST_ASSERT(RxObject(INT2FIX(1)) >= RxObject(INT2FIX(0)) == true);
		TEST_ASSERT(RxObject(INT2FIX(0)) >= RxObject(INT2FIX(1)) == false);
	}

	void test_ope_le()
	{
		TEST_ASSERT(RxObject(INT2FIX(0)) < RxObject(INT2FIX(0)) == false);
		TEST_ASSERT(RxObject(INT2FIX(1)) < RxObject(INT2FIX(0)) == false);
		TEST_ASSERT(RxObject(INT2FIX(0)) < RxObject(INT2FIX(1)) == true);
	}

	void test_ope_leq()
	{
		TEST_ASSERT(RxObject(INT2FIX(0)) <= RxObject(INT2FIX(0)) == true);
		TEST_ASSERT(RxObject(INT2FIX(1)) <= RxObject(INT2FIX(0)) == false);
		TEST_ASSERT(RxObject(INT2FIX(0)) <= RxObject(INT2FIX(1)) == true);
	}

	void test_value()
	{
		TEST_ASSERT(RxObject(Qnil).value() == Qnil);
		TEST_ASSERT(RxObject(Qtrue).value() == Qtrue);
		TEST_ASSERT(RxObject(Qfalse).value() == Qfalse);
	}

	void test_is_nil()
	{
		TEST_ASSERT(RxObject(Qnil).is_nil() == true);
		TEST_ASSERT(RxObject(Qtrue).is_nil() == false);
		TEST_ASSERT(RxObject(Qfalse).is_nil() == false);
	}

	void test_is_true()
	{
		TEST_ASSERT(RxObject(Qnil).is_true() == false);
		TEST_ASSERT(RxObject(Qtrue).is_true() == true);
		TEST_ASSERT(RxObject(Qfalse).is_true() == false);
	}

	void test_is_false()
	{
		TEST_ASSERT(RxObject(Qnil).is_false() == false);
		TEST_ASSERT(RxObject(Qtrue).is_false() == false);
		TEST_ASSERT(RxObject(Qfalse).is_false() == true);
	}

	void test_type()
	{
		TEST_ASSERT(RxObject().type().value() == rb_cObject);
	}

	void test_dup()
	{
		RxObject str1(RxString("str"));
		RxObject str2 = str1.dup_();

		TEST_ASSERT(str1 == str2);
		TEST_ASSERT(str2 == str1);
		TEST_ASSERT(str1.value() != str2.value());
	}

	void test_id()
	{
	}

	void test_inspect()
	{
		RxString s1("\"\"");
		TEST_ASSERT(RxString().inspect() == s1);
		TEST_ASSERT(RxNumeric().inspect() == RxString("0"));
		TEST_ASSERT(RxArray().inspect() == RxString("[]"));
		TEST_ASSERT(RxHash().inspect() == RxString("{}"));
	}

	void test_is_a()
	{
		TEST_ASSERT((bool)RxString::meta().is_a(RxObject::meta()) == true);
		TEST_ASSERT((bool)RxObject::meta().is_a(RxString::meta()) == false);
	}

	void test_kind_of()
	{
		TEST_ASSERT((bool)RxObject().kind_of(RxObject::meta()) == true);
		TEST_ASSERT((bool)RxString().kind_of(RxObject::meta()) == true);
		TEST_ASSERT((bool)RxString().kind_of(RxString::meta()) == true);
		TEST_ASSERT((bool)RxObject().kind_of(RxString::meta()) == false);
	}

};
