// $Id: RxKernel.h,v 1.8 2002/10/21 16:52:35 yuya Exp $

#if !defined(AFX_RXKERNEL_H__5E2E31AF_666A_4E38_A56E_498E3215BF3B__INCLUDED_)
#define AFX_RXKERNEL_H__5E2E31AF_666A_4E38_A56E_498E3215BF3B__INCLUDED_

#include "rubyxx/RxBase.h"
#include "rubyxx/RxObject.h"
#include "rubyxx/RxNil.h"
#include "rubyxx/RxString.h"
#include "rubyxx/RxClass.h"
#include "rubyxx/RxArray.h"
#include "rubyxx/RxIO.h"

class RxKernel
{

private:
	RxKernel();
	virtual ~RxKernel();

public:
	static RxClass meta();
	static RxObject abort();
	static RxObject at_exit();
	static RxObject autoload();
	static RxObject binding();
	static RxObject block_given_();
	static RxObject callcc();
	static RxObject caller();
	static RxObject catch_();
	static RxObject chomp();
	static RxObject chomp_();
	static RxObject chop();
	static RxObject chop_();
	static RxObject eval(RxString source, RxObject binding = RxNil());
	static RxObject exec();
	static RxObject exit();
	static RxObject exit_();
	static RxObject extend();
	static RxObject fail();
	static RxObject fork();
	static RxObject format(RxString format, RxArray args);
	static RxObject getc_();
	static RxObject gets();
	static RxObject global_variables();
	static RxObject gsub();
	static RxObject gsub_();
	static RxObject iterator_();
	static RxObject lambda();
	static RxObject load();
	static RxObject loop();
	static RxObject open();
	static RxObject p(RxObject obj);
	static RxObject print();
	static RxObject printf();
	static RxObject proc();
	static RxObject putc_();
	static RxObject puts();
	static RxObject raise();
	static RxObject rand();
	static RxObject readline();
	static RxObject readlines();
	static RxObject require(RxString filename);
	static RxObject scan();
	static RxObject select();
	static RxObject set_trace_func();
	static RxObject sleep_();
	static RxObject split();
	static RxObject sprintf();
	static RxObject srand();
	static RxObject sub();
	static RxObject sub_();
	static RxObject syscall();
	static RxObject system();
	static RxObject test();
	static RxObject throw_();
	static RxObject trace_var();
	static RxObject trap();
	static RxObject untrace_var();

	static RxIO STDIN();
	static RxIO STDOUT();
	static RxIO STDERR();

};

#endif
