// $Id: RxObject.h,v 1.17 2002/11/08 09:41:50 yuya Exp $

#if !defined(AFX_RXOBJECT_H__4F0241C5_16D9_4FF5_83F3_D8D6AB4FAFC2__INCLUDED_)
#define AFX_RXOBJECT_H__4F0241C5_16D9_4FF5_83F3_D8D6AB4FAFC2__INCLUDED_

#include "rubyxx/RxBase.h"
#include "rubyxx/RxID.h"

class RxClass;
class RxString;
class RxNumeric;
class RxArray;

class RxObject
{

public:
	RxObject();
	RxObject(const VALUE value);
	RxObject(const RxObject &obj);
	virtual ~RxObject();

public:
	virtual RxObject& operator=(RxObject& obj);

	virtual operator bool() const;
	virtual bool operator==(RxObject obj) const;
	virtual bool operator!=(RxObject obj) const;
	virtual bool operator>(RxObject obj) const;
	virtual bool operator>=(RxObject obj) const;
	virtual bool operator<(RxObject obj) const;
	virtual bool operator<=(RxObject obj) const;

public:
	virtual VALUE value() const;
	virtual bool is_nil() const;
	virtual bool is_true() const;
	virtual bool is_false() const;

	virtual RxObject mcall(RxID mid) const;
	virtual RxObject mcall(RxID mid, RxObject p1) const;
	virtual RxObject mcall(RxID mid, RxObject p1, RxObject p2) const;
	virtual RxObject apply(RxID mid, RxArray args) const;
	virtual RxObject apply(RxID mid, RxObject arg1, RxArray argx) const;

	virtual RxObject class_() const;
	virtual RxObject clone() const;
	virtual RxObject display() const;
	virtual RxObject dup_() const;
	virtual RxObject eql() const;
	virtual RxObject equal() const;
	virtual RxObject extend() const;
	virtual RxObject freeze() const;
	virtual RxObject frozen() const;
	virtual RxNumeric hash() const;
	virtual RxNumeric id() const;
	virtual RxString inspect() const;
	virtual RxObject instance_eval() const;
	virtual RxObject instance_of() const;
	virtual RxObject instance_variables() const;
	virtual RxObject is_a(RxObject obj) const;
	virtual RxObject kind_of(RxObject obj) const;
	virtual RxObject method() const;
	virtual RxObject methods() const;
	virtual RxObject private_methods() const;
	virtual RxObject protected_methods() const;
	virtual RxObject public_methods() const;
	virtual RxObject singleton_methods() const;
	virtual RxObject taint() const;
	virtual RxObject tainted() const;
	virtual RxObject to_a() const;
	virtual RxObject to_ary() const;
	virtual RxObject to_hash() const;
	virtual RxObject to_int() const;
	virtual RxString to_s() const;
	virtual RxString to_str() const;
	virtual RxClass  type() const;
	virtual RxObject untaint() const;

public:
	static RxClass meta();
	static RxObject new_();
	static void dump_objects();

protected:
	static void register_global_variable(VALUE value);
	static void unregister_global_variable(VALUE value);

protected:
	VALUE m_value;

protected:
	static VALUE m_gvar;

};

#endif
