// $Id: RxArray.cpp,v 1.5 2002/11/08 09:32:25 yuya Exp $

#include "rubyxx/RxArray.h"

////////////////////////////////////////////////////////////////////////////////

RxArray::RxArray()
	: RxObject(::rb_ary_new())
{
}

RxArray::RxArray(const RxObject& obj)
	: RxObject(obj)
{
}

RxArray::RxArray(int n, ...)
	: RxObject(::rb_ary_new2(n))
{
    va_list ar;
	va_start(ar, n);

	for ( int i = 0; i < n; i++ ) {
		this->push(va_arg(ar, RxObject));
	}

	va_end(ar);
}

RxArray::~RxArray()
{
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxArray::operator[](int idx) const
{
	return (*this)[RxNumeric(idx)];
}

RxObject
RxArray::operator[](RxObject idx) const
{
	return mcall("[]", idx);
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxArray::assoc(RxObject key) const
{
	return mcall("assoc", key);
}

RxObject
RxArray::at(RxObject pos) const
{
	return mcall("at", pos);
}

RxObject
RxArray::clear() const
{
	return mcall("clear");
}

RxObject
RxArray::collect_() const
{
	return mcall("collect!");
}

RxObject
RxArray::compact() const
{
	return mcall("compact");
}

RxObject
RxArray::compact_() const
{
	return mcall("compact!");
}

RxObject
RxArray::concat(RxObject other) const
{
	return mcall("concat", other);
}

RxObject
RxArray::delete_(RxObject val) const
{
	return mcall("delete", val);
}

RxObject
RxArray::delete_at(RxObject pos) const
{
	return mcall("delete_at", pos);
}

RxObject
RxArray::delete_if() const
{
	return mcall("delete_if");
}

RxObject
RxArray::each() const
{
	return mcall("each");
}

RxObject
RxArray::each_index() const
{
	return mcall("each_index");
}

RxObject
RxArray::empty_() const
{
	return mcall("empty?");
}

RxObject
RxArray::fill(RxObject val) const
{
	return mcall("fill");
}

RxObject
RxArray::filter() const
{
	return mcall("filter");
}

RxObject
RxArray::first() const
{
	return mcall("first");
}

RxObject
RxArray::flatten() const
{
	return mcall("flatten");
}

RxObject
RxArray::flatten_() const
{
	return mcall("flatten!");
}

RxObject
RxArray::index(RxObject val) const
{
	return mcall("index", val);
}

RxObject
RxArray::indexes(RxObject index) const
{
	return mcall("indexes", index);
}

RxObject
RxArray::indices(RxObject index) const
{
	return mcall("indices", index);
}

RxObject
RxArray::join(RxObject sep) const
{
	return mcall("join", sep);
}

RxObject
RxArray::last() const
{
	return mcall("last");
}

RxObject
RxArray::length() const
{
	return mcall("length");
}

RxObject
RxArray::map_() const
{
	return mcall("map!");
}

RxObject
RxArray::nitems() const
{
	return mcall("nitems");
}

RxObject
RxArray::pack(RxObject template_) const
{
	return mcall("pack", template_);
}

RxObject
RxArray::pop() const
{
	return RxObject(::rb_ary_pop(m_value));
}

RxObject
RxArray::push(RxObject obj) const
{
	return RxObject(::rb_ary_push(m_value, obj.value()));
}

RxObject
RxArray::rassoc(RxObject obj) const
{
	return mcall("rassoc", obj);
}

RxObject
RxArray::reject_() const
{
	return mcall("reject!");
}

RxObject
RxArray::replace(RxObject another) const
{
	return mcall("replace", another);
}

RxObject
RxArray::reverse() const
{
	return mcall("reverse");
}

RxObject
RxArray::reverse_() const
{
	return mcall("reverse!");
}

RxObject
RxArray::reverse_each() const
{
	return mcall("reverse_each");
}

RxObject
RxArray::rindex(RxObject val) const
{
	return mcall("rindex", val);
}

RxObject
RxArray::shift() const
{
	return mcall("shift");
}

RxObject
RxArray::size() const
{
	return mcall("size");
}

RxObject
RxArray::slice(RxObject range) const
{
	return mcall("slice", range);
}

RxObject
RxArray::slice_(RxObject range) const
{
	return mcall("slice!", range);
}

RxObject
RxArray::sort_() const
{
	return mcall("sort!");
}

RxObject
RxArray::to_ary() const
{
	return mcall("to_ary");
}

RxObject
RxArray::uniq() const
{
	return mcall("uniq");
}

RxObject
RxArray::uniq_() const
{
	return mcall("uniq!");
}

RxObject
RxArray::unshift(RxObject obj) const
{
	return mcall("unshift", obj);
}

////////////////////////////////////////////////////////////////////////////////
