// $Id: RxFile.cpp,v 1.2 2002/10/21 14:17:39 yuya Exp $

#include "rubyxx/RxFile.h"

////////////////////////////////////////////////////////////////////////////////

RxFile::RxFile()
	: RxIO()
{
}

RxFile::RxFile(const RxObject& obj)
	: RxIO(obj)
{
}

RxFile::~RxFile()
{
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxFile::atime() const
{
	return mcall("atime");
}

RxObject
RxFile::chmod() const
{
	return mcall("chmod");
}

RxObject
RxFile::chown() const
{
	return mcall("chown");
}

RxObject
RxFile::ctime() const
{
	return mcall("ctime");
}

RxObject
RxFile::flock() const
{
	return mcall("flock");
}

RxObject
RxFile::lstat() const
{
	return mcall("lstat");
}

RxObject
RxFile::mtime() const
{
	return mcall("mtime");
}

RxObject
RxFile::path() const
{
	return mcall("path");
}

RxObject
RxFile::truncate() const
{
	return mcall("truncate");
}

////////////////////////////////////////////////////////////////////////////////

RxClass
RxFile::meta()
{
	return RxClass(RxObject(rb_cFile));
}

RxFile
RxFile::open_(RxString path, RxString mode)
{
	return meta().mcall("open", path, mode);
}

////////////////////////////////////////////////////////////////////////////////
