// $Id: RxHash.cpp,v 1.2 2002/10/21 14:17:39 yuya Exp $

#include "rubyxx/RxHash.h"

////////////////////////////////////////////////////////////////////////////////

RxHash::RxHash()
	: RxObject(::rb_hash_new())
{
}

RxHash::RxHash(const RxObject& obj)
	: RxObject(obj)
{
}

RxHash::~RxHash()
{
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxHash::clear() const
{
	return mcall("clear");
}

RxObject
RxHash::default_() const
{
	return mcall("default");
}

RxObject
RxHash::default__() const
{
	return mcall("default=");
}

RxObject
RxHash::delete_(RxObject key) const
{
	return mcall("delete", key);
}

RxObject
RxHash::delete_if() const
{
	return mcall("delete_if");
}

RxObject
RxHash::each() const
{
	return mcall("each");
}

RxObject
RxHash::each_key() const
{
	return mcall("each_key");
}

RxObject
RxHash::each_pair() const
{
	return mcall("each_pair");
}

RxObject
RxHash::each_value() const
{
	return mcall("each_value");
}

RxObject
RxHash::empty_() const
{
	return mcall("empty?");
}

RxObject
RxHash::fetch(RxObject key, RxObject default_) const
{
	return mcall("fetch", key, default_);
}

RxObject
RxHash::has_key_(RxObject key) const
{
	return mcall("has_key?", key);
}

RxObject
RxHash::has_value_(RxObject value) const
{
	return mcall("has_value?", value);
}

RxObject
RxHash::index(RxObject val) const
{
	return mcall("index", val);
}

RxObject
RxHash::indexes(RxObject key) const
{
	return mcall("indexes", key);
}

RxObject
RxHash::indices(RxObject key) const
{
	return mcall("indices", key);
}

RxObject
RxHash::invert() const
{
	return mcall("invert");
}

RxObject
RxHash::key_() const
{
	return mcall("key?");
}

RxObject
RxHash::keys() const
{
	return mcall("keys");
}

RxObject
RxHash::length() const
{
	return mcall("length");
}

RxObject
RxHash::rehash() const
{
	return mcall("rehash");
}

RxObject
RxHash::reject_() const
{
	return mcall("reject!");
}

RxObject
RxHash::replace(RxObject other) const
{
	return mcall("replace", other);
}

RxObject
RxHash::shift() const
{
	return mcall("shift");
}

RxObject
RxHash::size() const
{
	return mcall("size");
}

RxObject
RxHash::store(RxObject key, RxObject value) const
{
	return mcall("store", key, value);
}

RxObject
RxHash::to_hash() const
{
	return mcall("to_hash");
}

RxObject
RxHash::update(RxObject other) const
{
	return mcall("update", other);
}

RxObject
RxHash::value_(RxObject value) const
{
	return mcall("value?", value);
}

RxObject
RxHash::values() const
{
	return mcall("values");
}

////////////////////////////////////////////////////////////////////////////////
