// $Id: RxIO.cpp,v 1.2 2002/10/21 14:17:39 yuya Exp $

#include "rubyxx/RxIO.h"

////////////////////////////////////////////////////////////////////////////////

RxIO::RxIO()
	: RxObject()
{
}

RxIO::RxIO(const RxObject& obj)
	: RxObject(obj)
{
}

RxIO::~RxIO()
{
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxIO::binmode() const
{
	return mcall("binmode");
}

RxObject
RxIO::close_() const
{
	return mcall("close");
}

RxObject
RxIO::close_read() const
{
	return mcall("close_read");
}

RxObject
RxIO::close_write() const
{
	return mcall("close_write");
}

RxObject
RxIO::closed_() const
{
	return mcall("closed?");
}

RxObject
RxIO::each() const
{
	return mcall("each");
}

RxObject
RxIO::each_byte() const
{
	return mcall("each_byte");
}

RxObject
RxIO::each_line() const
{
	return mcall("each_line");
}

RxObject
RxIO::eof() const
{
	return mcall("eof");
}

RxObject
RxIO::eof_() const
{
	return mcall("eof?");
}

RxObject
RxIO::fcntl() const
{
	return mcall("fcntl");
}

RxObject
RxIO::fileno() const
{
	return mcall("fileno");
}

RxObject
RxIO::flush() const
{
	return mcall("flush");
}

RxObject
RxIO::getc_() const
{
	return mcall("getc");
}

RxObject
RxIO::gets() const
{
	return mcall("gets");
}

RxObject
RxIO::ioctl() const
{
	return mcall("ioctl");
}

RxObject
RxIO::isatty() const
{
	return mcall("isatty");
}

RxObject
RxIO::lineno() const
{
	return mcall("lineno");
}

RxObject
RxIO::lineno_() const
{
	return mcall("lineno=");
}

RxObject
RxIO::pid() const
{
	return mcall("pid");
}

RxObject
RxIO::pos() const
{
	return mcall("pos");
}

RxObject
RxIO::pos_() const
{
	return mcall("pos=");
}

RxObject
RxIO::print() const
{
	return mcall("print");
}

RxObject
RxIO::printf(RxString format, RxArray args) const
{
	return apply("printf", format, args);
}

RxObject
RxIO::putc_() const
{
	return mcall("putc");
}

RxObject
RxIO::puts(RxObject obj) const
{
	return mcall("puts", obj);
}

RxString
RxIO::read_() const
{
	return mcall("read");
}

RxObject
RxIO::readchar() const
{
	return mcall("readchar");
}

RxObject
RxIO::readline() const
{
	return mcall("readline");
}

RxObject
RxIO::readlines() const
{
	return mcall("readlines");
}

RxObject
RxIO::reopen() const
{
	return mcall("reopen");
}

RxObject
RxIO::rewind() const
{
	return mcall("rewind");
}

RxObject
RxIO::seek() const
{
	return mcall("seek");
}

RxObject
RxIO::stat() const
{
	return mcall("stat");
}

RxObject
RxIO::sync() const
{
	return mcall("sync");
}

RxObject
RxIO::sync_() const
{
	return mcall("sync=");
}

RxObject
RxIO::sysread() const
{
	return mcall("sysread");
}

RxObject
RxIO::syswrite() const
{
	return mcall("syswrite");
}

RxObject
RxIO::tell() const
{
	return mcall("tell");
}

RxObject
RxIO::to_i() const
{
	return mcall("to_i");
}

RxObject
RxIO::to_io() const
{
	return mcall("to_io");
}

RxObject
RxIO::tty_() const
{
	return mcall("tty?");
}

RxObject
RxIO::ungetc() const
{
	return mcall("ungetc");
}

RxObject
RxIO::write() const
{
	return mcall("write");
}

////////////////////////////////////////////////////////////////////////////////
