// $Id: RxKernel.cpp,v 1.4 2002/10/21 16:52:35 yuya Exp $

#include "rubyxx/RxKernel.h"

////////////////////////////////////////////////////////////////////////////////

RxKernel::RxKernel()
{
}

RxKernel::~RxKernel()
{
}

////////////////////////////////////////////////////////////////////////////////

RxClass
RxKernel::meta()
{
	return RxClass(RxObject(rb_mKernel));
}

RxObject
RxKernel::abort()
{
	return meta().mcall("abort");
}

RxObject
RxKernel::at_exit()
{
	return meta().mcall("at_exit");
}

RxObject
RxKernel::autoload()
{
	return meta().mcall("autoload");
}

RxObject
RxKernel::binding()
{
	return meta().mcall("binding");
}

RxObject
RxKernel::block_given_()
{
	return meta().mcall("block_given?");
}

RxObject
RxKernel::callcc()
{
	return meta().mcall("callcc");
}

RxObject
RxKernel::caller()
{
	return meta().mcall("caller");
}

RxObject
RxKernel::catch_()
{
	return meta().mcall("catch");
}

RxObject
RxKernel::chomp()
{
	return meta().mcall("chomp");
}

RxObject
RxKernel::chomp_()
{
	return meta().mcall("chomp!");
}

RxObject
RxKernel::chop()
{
	return meta().mcall("chop");
}

RxObject
RxKernel::chop_()
{
	return meta().mcall("chop!");
}

RxObject
RxKernel::eval(RxString source, RxObject binding)
{
	if ( !binding.is_nil() ) {
		return meta().mcall("eval", source);
	} else {
		return meta().mcall("eval", source, binding);
	}
}

RxObject
RxKernel::exec()
{
	return meta().mcall("exec");
}

RxObject
RxKernel::exit()
{
	return meta().mcall("exit");
}

RxObject
RxKernel::exit_()
{
	return meta().mcall("exit!");
}

RxObject
RxKernel::extend()
{
	return meta().mcall("extend");
}

RxObject
RxKernel::fail()
{
	return meta().mcall("fail");
}

RxObject
RxKernel::fork()
{
	return meta().mcall("fork");
}

RxObject
RxKernel::format(RxString format, RxArray args)
{
	return meta().apply("format", format, args);
}

RxObject
RxKernel::getc_()
{
	return meta().mcall("getc");
}

RxObject
RxKernel::gets()
{
	return meta().mcall("gets");
}

RxObject
RxKernel::global_variables()
{
	return meta().mcall("global_variables");
}

RxObject
RxKernel::gsub()
{
	return meta().mcall("gsub");
}

RxObject
RxKernel::gsub_()
{
	return meta().mcall("gsub!");
}

RxObject
RxKernel::iterator_()
{
	return meta().mcall("iterator?");
}

RxObject
RxKernel::lambda()
{
	return meta().mcall("lambda");
}

RxObject
RxKernel::load()
{
	return meta().mcall("load");
}

RxObject
RxKernel::loop()
{
	return meta().mcall("loop");
}

RxObject
RxKernel::open()
{
	return meta().mcall("open");
}

RxObject
RxKernel::p(RxObject obj)
{
	return meta().mcall("p", obj);
}

RxObject
RxKernel::print()
{
	return meta().mcall("print");
}

RxObject
RxKernel::printf()
{
	return meta().mcall("printf");
}

RxObject
RxKernel::proc()
{
	return meta().mcall("proc");
}

RxObject
RxKernel::putc_()
{
	return meta().mcall("putc");
}

RxObject
RxKernel::puts()
{
	return meta().mcall("puts");
}

RxObject
RxKernel::raise()
{
	return meta().mcall("raise");
}

RxObject
RxKernel::rand()
{
	return meta().mcall("rand");
}

RxObject
RxKernel::readline()
{
	return meta().mcall("readline");
}

RxObject
RxKernel::readlines()
{
	return meta().mcall("readlines");
}

RxObject
RxKernel::require(RxString filename)
{
	return meta().mcall("require", filename);
}

RxObject
RxKernel::scan()
{
	return meta().mcall("scan");
}

RxObject
RxKernel::select()
{
	return meta().mcall("select");
}

RxObject
RxKernel::set_trace_func()
{
	return meta().mcall("set_trace_func");
}

RxObject
RxKernel::sleep_()
{
	return meta().mcall("sleep");
}

RxObject
RxKernel::split()
{
	return meta().mcall("split");
}

RxObject
RxKernel::sprintf()
{
	return meta().mcall("sprintf");
}

RxObject
RxKernel::srand()
{
	return meta().mcall("srand");
}

RxObject
RxKernel::sub()
{
	return meta().mcall("sub");
}

RxObject
RxKernel::sub_()
{
	return meta().mcall("sub!");
}

RxObject
RxKernel::syscall()
{
	return meta().mcall("syscall");
}

RxObject
RxKernel::system()
{
	return meta().mcall("system");
}

RxObject
RxKernel::test()
{
	return meta().mcall("test");
}

RxObject
RxKernel::throw_()
{
	return meta().mcall("throw");
}

RxObject
RxKernel::trace_var()
{
	return meta().mcall("trace_var");
}

RxObject
RxKernel::trap()
{
	return meta().mcall("trap");
}

RxObject
RxKernel::untrace_var()
{
	return meta().mcall("untrace_var");
}


RxIO
RxKernel::STDIN()
{
	return RxIO(RxObject::meta().get_const("STDIN"));
}

RxIO
RxKernel::STDOUT()
{
	return RxIO(RxObject::meta().get_const("STDOUT"));
}

RxIO
RxKernel::STDERR()
{
	return RxIO(RxObject::meta().get_const("STDERR"));
}

////////////////////////////////////////////////////////////////////////////////
