// $Id: RxObject.cpp,v 1.6 2002/11/08 09:41:50 yuya Exp $

#include "rubyxx/RxObject.h"
#include "rubyxx/RxID.h"
#include "rubyxx/RxKernel.h"
#include "rubyxx/RxClass.h"
#include "rubyxx/RxString.h"
#include "rubyxx/RxNumeric.h"
#include "rubyxx/RxArray.h"

////////////////////////////////////////////////////////////////////////////////

VALUE RxObject::m_gvar = 0;

////////////////////////////////////////////////////////////////////////////////

RxObject::RxObject()
{
	m_value = RxKernel::eval("::Object.new").value();
	RxObject::register_global_variable(m_value);
}

RxObject::RxObject(const VALUE value)
{
	m_value = value;
	RxObject::register_global_variable(m_value);
}

RxObject::RxObject(const RxObject &obj)
{
	m_value = obj.m_value;
	RxObject::register_global_variable(m_value);
}

RxObject::~RxObject()
{
	RxObject::unregister_global_variable(m_value);
	m_value = 0;
}

////////////////////////////////////////////////////////////////////////////////

inline VALUE
RxObject::value() const
{
	return m_value;
}

////////////////////////////////////////////////////////////////////////////////

RxObject&
RxObject::operator=(RxObject& obj)
{
	RxObject::unregister_global_variable(m_value);
	m_value = obj.m_value;
	RxObject::register_global_variable(m_value);

	return *this;
}

RxObject::operator bool() const
{
	return !(is_nil() || is_false());
}

bool
RxObject::operator==(RxObject obj) const
{
	return this->mcall("==", obj).is_true();
}

bool
RxObject::operator!=(RxObject obj) const
{
	return !(*this == obj);
}

bool
RxObject::operator>(RxObject obj) const
{
	return this->mcall(">", obj).is_true();
}

bool
RxObject::operator>=(RxObject obj) const
{
	return this->mcall(">=", obj).is_true();
}

bool
RxObject::operator<(RxObject obj) const
{
	return this->mcall("<", obj).is_true();
}

bool
RxObject::operator<=(RxObject obj) const
{
	return this->mcall("<=", obj).is_true();
}

////////////////////////////////////////////////////////////////////////////////

inline bool
RxObject::is_nil() const
{
	return (m_value == Qnil);
}

inline bool
RxObject::is_true() const
{
	return (m_value == Qtrue);
}

inline bool
RxObject::is_false() const
{
	return (m_value == Qfalse);
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxObject::mcall(RxID mid) const
{
	return ::rb_funcall(m_value, mid.id(), 0);
}

RxObject
RxObject::mcall(RxID mid, RxObject p1) const
{
	return ::rb_funcall(m_value, mid.id(), 1, p1.value());
}

RxObject
RxObject::mcall(RxID mid, RxObject p1, RxObject p2) const
{
	return ::rb_funcall(m_value, mid.id(), 2, p1.value(), p2.value());
}

RxObject
RxObject::apply(RxID mid, RxArray args) const
{
	return ::rb_apply(m_value, mid.id(), args.value());
}

RxObject
RxObject::apply(RxID mid, RxObject arg1, RxArray argx) const
{
	RxArray args;
	args.push(arg1);
	args.concat(argx);
	return apply(mid, args);
}

RxObject
RxObject::class_() const
{
	return mcall("class");
}

RxObject
RxObject::clone() const
{
	return mcall("clone");
}

RxObject
RxObject::display() const
{
	return mcall("display");
}

RxObject
RxObject::dup_() const
{
	return mcall("dup");
}

RxObject
RxObject::eql() const
{
	return mcall("eql?");
}

RxObject
RxObject::equal() const
{
	return mcall("equal?");
}

RxObject
RxObject::extend() const
{
	return mcall("extend");
}

RxObject
RxObject::freeze() const
{
	return mcall("freeze");
}

RxObject
RxObject::frozen() const
{
	return mcall("frozen?");
}

RxNumeric
RxObject::hash() const
{
	return RxNumeric(mcall("hash"));
}

RxNumeric
RxObject::id() const
{
	return RxNumeric(mcall("id"));
}


RxString
RxObject::inspect() const
{
	return RxString(RxObject(::rb_inspect(m_value)));
}

RxObject
RxObject::instance_eval() const
{
	return mcall("instance_eval");
}

RxObject
RxObject::instance_of() const
{
	return mcall("instance_of?");
}

RxObject
RxObject::instance_variables() const
{
	return mcall("instance_variables");
}

RxObject
RxObject::is_a(RxObject obj) const
{
	return mcall("is_a?", obj);
}

RxObject
RxObject::kind_of(RxObject obj) const
{
	return mcall("kind_of?", obj);
}

RxObject
RxObject::method() const
{
	return mcall("method");
}

RxObject
RxObject::methods() const
{
	return mcall("methods");
}

RxObject
RxObject::private_methods() const
{
	return mcall("private_methods");
}

RxObject
RxObject::protected_methods() const
{
	return mcall("protected_methods");
}

RxObject
RxObject::public_methods() const
{
	return mcall("public_methods");
}

RxObject
RxObject::singleton_methods() const
{
	return mcall("singleton_methods");
}

RxObject
RxObject::taint() const
{
	return mcall("taint");
}

RxObject
RxObject::tainted() const
{
	return mcall("tainted");
}

RxObject
RxObject::to_a() const
{
	return mcall("to_a");
}

RxObject
RxObject::to_ary() const
{
	return mcall("to_ary");
}

RxObject
RxObject::to_hash() const
{
	return mcall("to_hash");
}

RxObject
RxObject::to_int() const
{
	return mcall("to_int");
}

RxString
RxObject::to_s() const
{
	return mcall("to_s");
}

RxString
RxObject::to_str() const
{
	return mcall("to_str");
}

RxClass
RxObject::type() const
{
	return RxClass(mcall("type"));
}

RxObject
RxObject::untaint() const
{
	return mcall("untaint");
}

////////////////////////////////////////////////////////////////////////////////

RxClass
RxObject::meta()
{
	return RxObject(rb_cObject);
}

RxObject
RxObject::new_()
{
	return meta().mcall("new");
}

void
RxObject::dump_objects()
{
	::rb_p(m_gvar);
}

////////////////////////////////////////////////////////////////////////////////

void
RxObject::register_global_variable(VALUE value)
{
	if ( !FIXNUM_P(value) ) {
		if ( !m_gvar ) {
			m_gvar = ::rb_hash_new();
			::rb_global_variable(&m_gvar);
		}

		VALUE key   = INT2NUM(value);
		VALUE entry = ::rb_hash_aref(m_gvar, key);

		if ( entry == Qnil ) {
			entry = rb_ary_new3(2, value, INT2FIX(1));
			::rb_hash_aset(m_gvar, key, entry);
		} else {
			VALUE obj    = ::rb_ary_entry(entry, 0);
			VALUE count  = ::rb_ary_entry(entry, 1);
			VALUE count2 = ::rb_funcall(count, ::rb_intern("+"), 1, INT2FIX(1));
			::rb_ary_store(entry, 1, count2);
		}
	}
}

void
RxObject::unregister_global_variable(VALUE value)
{
	if ( !FIXNUM_P(value) ) {
		VALUE key   = INT2NUM(value);
		VALUE entry = ::rb_hash_aref(m_gvar, key);

		VALUE count  = ::rb_ary_entry(entry, 1);
		VALUE count2 = ::rb_funcall(count, ::rb_intern("-"), 1, INT2FIX(1));

		if ( FIX2INT(count2) <= 0 ) {
			::rb_funcall(m_gvar, ::rb_intern("delete"), 1, key);
		} else {
			::rb_ary_store(entry, 1, count2);
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
