// $Id: RxString.cpp,v 1.3 2002/11/08 09:32:25 yuya Exp $

#include "rubyxx/RxString.h"

////////////////////////////////////////////////////////////////////////////////

RxString::RxString()
	: RxObject(::rb_str_new2(""))
{
}

RxString::RxString(const RxObject& Object)
	: RxObject(Object)
{
}

RxString::RxString(const char* string)
	: RxObject(::rb_str_new2(string))
{
}

RxString::~RxString()
{
}

////////////////////////////////////////////////////////////////////////////////

RxString::operator const char*() const
{
	return string();
}

const char*
RxString::string() const
{
	return STR2CSTR(m_value);
}

RxString
RxString::operator*(RxNumeric num) const
{
	return RxString(*this * num);
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxString::capitalize() const
{
	return mcall("capitalize");
}

RxObject
RxString::capitalize_() const
{
	return mcall("capitalize!");
}

RxObject
RxString::center(RxObject width) const
{
	return mcall("center", width);
}

RxObject
RxString::chomp(RxObject rs) const
{
	return mcall("chomp", rs);
}

RxObject
RxString::chomp_(RxObject rs) const
{
	return mcall("chomp!", rs);
}

RxObject
RxString::chop() const
{
	return mcall("chop");
}

RxObject
RxString::chop_() const
{
	return mcall("chop!");
}

RxObject
RxString::concat(RxObject other) const
{
	return mcall("concat", other);
}

RxObject
RxString::count(RxObject str) const
{
	return mcall("count", str);
}

RxObject
RxString::crypt(RxObject salt) const
{
	return mcall("crypt", salt);
}

RxObject
RxString::delete_(RxObject str) const
{
	return mcall("delete", str);
}

RxObject
RxString::delete__(RxObject str) const
{
	return mcall("delete!", str);
}

RxObject
RxString::downcase() const
{
	return mcall("downcase");
}

RxObject
RxString::downcase_() const
{
	return mcall("downcase!");
}

RxObject
RxString::dump() const
{
	return mcall("dump");
}

RxObject
RxString::each(RxObject rs) const
{
	return mcall("each", rs);
}

RxObject
RxString::each_byte() const
{
	return mcall("each_byte");
}

RxObject
RxString::each_line(RxObject rs) const
{
	return mcall("each_line", rs);
}

RxObject
RxString::empty_() const
{
	return mcall("empty");
}

RxObject
RxString::gsub(RxObject pattern, RxObject replace) const
{
	return mcall("gsub", pattern, replace);
}

RxObject
RxString::gsub_(RxObject pattern, RxObject replace) const
{
	return mcall("gsub", pattern, replace);
}

RxObject
RxString::hex() const
{
	return mcall("hex");
}

RxObject
RxString::index(RxObject pattern, RxObject pos) const
{
	return mcall("index", pattern, pos);
}

RxObject
RxString::intern() const
{
	return mcall("intern");
}

RxNumeric
RxString::length() const
{
	return mcall("length");
}

RxObject
RxString::ljust(RxObject width) const
{
	return mcall("ljust");
}

RxObject
RxString::next() const
{
	return mcall("next");
}

RxObject
RxString::next_() const
{
	return mcall("next!");
}

RxObject
RxString::oct() const
{
	return mcall("oct");
}

RxObject
RxString::replace(RxObject other) const
{
	return mcall("replace");
}

RxObject
RxString::reverse() const
{
	return mcall("reverse");
}

RxObject
RxString::reverse_() const
{
	return mcall("reverse!");
}

RxObject
RxString::rindex(RxObject pattern, RxObject pos) const
{
	return mcall("rindex", pattern, pos);
}

RxObject
RxString::rjust(RxObject width) const
{
	return mcall("rjust", width);
}

RxObject
RxString::scan(RxObject re) const
{
	return mcall("scan", re);
}

RxNumeric
RxString::size() const
{
	return mcall("size");
}

RxObject
RxString::slice(RxObject range) const
{
	return mcall("slice");
}

RxObject
RxString::slice_(RxObject range) const
{
	return mcall("slice!");
}

RxObject
RxString::split(RxObject sep, RxObject limit) const
{
	return mcall("split", sep, limit);
}

RxObject
RxString::squeeze(RxObject str) const
{
	return mcall("squeeze", str);
}

RxObject
RxString::squeeze_(RxObject str) const
{
	return mcall("squeeze!", str);
}

RxObject
RxString::strip() const
{
	return mcall("strip");
}

RxObject
RxString::strip_() const
{
	return mcall("strip!");
}

RxObject
RxString::sub(RxObject pattern, RxObject replace) const
{
	return mcall("sub", pattern, replace);
}

RxObject
RxString::sub_(RxObject pattern, RxObject replace) const
{
	return mcall("sub", pattern, replace);
}

RxObject
RxString::succ() const
{
	return mcall("succ");
}

RxObject
RxString::succ_() const
{
	return mcall("succ!");
}

RxObject
RxString::sum(RxObject bits) const
{
	return mcall("sum", bits);
}

RxObject
RxString::swapcase() const
{
	return mcall("swapcase");
}

RxObject
RxString::swapcase_() const
{
	return mcall("swapcase!");
}

RxObject
RxString::to_f() const
{
	return mcall("to_f");
}

RxObject
RxString::to_i() const
{
	return mcall("to_i");
}

RxObject
RxString::tr(RxObject search, RxObject replace) const
{
	return mcall("tr", search, replace);
}

RxObject
RxString::tr_(RxObject search, RxObject replace) const
{
	return mcall("tr!", search, replace);
}

RxObject
RxString::tr_s(RxObject search, RxObject replace) const
{
	return mcall("tr_s", search, replace);
}

RxObject
RxString::tr_s_(RxObject search, RxObject replace) const
{
	return mcall("tr_s!", search, replace);
}

RxObject
RxString::unpack(RxObject template_) const
{
	return mcall("unpack", template_);
}

RxObject
RxString::upcase() const
{
	return mcall("upcase");
}

RxObject
RxString::upcase_() const
{
	return mcall("upcase!");
}

RxObject
RxString::upto(RxObject max) const
{
	return mcall("upto", max);
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxString::meta()
{
	return RxObject(rb_cString);
}

////////////////////////////////////////////////////////////////////////////////
