
#include "RxArray.h"

RxArray::RxArray()
	: RxObject(::rb_ary_new())
{
}

RxArray::RxArray(RxObject& Object)
	: RxObject(Object)
{
}

RxArray::~RxArray()
{
}


RxObject
RxArray::operator[](int idx) const
{
	return (*this)[RxNumeric(idx)];
}

RxObject
RxArray::operator[](RxObject idx) const
{
	static RxID method("[]");
	return send(method, idx);
}


RxObject
RxArray::pop() const
{
	return RxObject(::rb_ary_pop(m_vObject));
}

RxObject
RxArray::push(RxObject obj) const
{
	return RxObject(::rb_ary_push(m_vObject, obj.value()));
}
