
#include "RxObject.h"
#include "RxID.h"
#include "RxKernel.h"
#include "RxString.h"
#include "RxClass.h"

VALUE RxObject::m_vGlobalVariable = 0;

RxObject::RxObject()
{
//	::OutputDebugString("RxObject::RxObject()\n");

	m_vObject = RxKernel::eval("Object.new").value();

	RxObject::register_global_variable(m_vObject);
}

RxObject::RxObject(VALUE vObject)
{
//	::OutputDebugString("RxObject::RxObject()\n");

	m_vObject = vObject;

	RxObject::register_global_variable(m_vObject);
}

RxObject::RxObject(RxObject &Object)
{
//	::OutputDebugString("RxObject::RxObject()\n");

	m_vObject = Object.m_vObject;

	RxObject::register_global_variable(m_vObject);
}

RxObject::~RxObject()
{
//	::OutputDebugString("RxObject::~RxObject()\n");

	RxObject::unregister_global_variable(m_vObject);
}


VALUE
RxObject::value() const
{
	return m_vObject;
}

bool
RxObject::is_nil() const
{
	return (m_vObject == Qnil);
}

bool
RxObject::is_true() const
{
	return (m_vObject == Qtrue);
}

bool
RxObject::is_false() const
{
	return (m_vObject == Qfalse);
}


RxObject
RxObject::send(RxID method_name) const
{
	return ::rb_funcall(m_vObject, method_name.id(), 0);
}

RxObject
RxObject::send(RxID method_name, RxObject param1) const
{
	return ::rb_funcall(m_vObject, method_name.id(), 1, (VALUE)param1.value());
}

RxClass
RxObject::type() const
{
	return RxClass(send(RxID("type")));
}

RxString
RxObject::inspect() const
{
	return RxString(RxObject(::rb_inspect(m_vObject)));
}


void
RxObject::register_global_variable(VALUE value)
{
	if ( !m_vGlobalVariable ) {
		m_vGlobalVariable = ::rb_hash_new();
		::rb_global_variable(&m_vGlobalVariable);
	}

	VALUE key   = INT2NUM(value);
	VALUE entry = ::rb_hash_aref(m_vGlobalVariable, key);

	if ( entry == Qnil ) {
		entry = rb_ary_new3(2, value, INT2FIX(1));
		::rb_hash_aset(m_vGlobalVariable, key, entry);
	} else {
		VALUE obj    = ::rb_ary_entry(entry, 0);
		VALUE count  = ::rb_ary_entry(entry, 1);
		VALUE count2 = ::rb_funcall(count, ::rb_intern("+"), 1, INT2FIX(1));
		::rb_ary_store(entry, 1, count2);
	}
}

void
RxObject::unregister_global_variable(VALUE value)
{
	VALUE key   = INT2NUM(value);
	VALUE entry = ::rb_hash_aref(m_vGlobalVariable, key);

	VALUE count  = ::rb_ary_entry(entry, 1);
	VALUE count2 = ::rb_funcall(count, ::rb_intern("-"), 1, INT2FIX(1));

	if ( FIX2INT(count2) <= 0 ) {
		::rb_funcall(m_vGlobalVariable, ::rb_intern("delete"), 1, key);
	} else {
		::rb_ary_store(entry, 1, count2);
	}
}
