
#include "rubyxx/RxArray.h"

RxArray::RxArray()
	: RxObject(::rb_ary_new())
{
}

RxArray::RxArray(RxObject& obj)
	: RxObject(obj)
{
}

RxArray::~RxArray()
{
}


RxObject
RxArray::operator[](int idx) const
{
	return (*this)[RxNumeric(idx)];
}

RxObject
RxArray::operator[](RxObject idx) const
{
	return send("[]", idx);
}


RxObject
RxArray::assoc() const
{
	return send("assoc");
}

RxObject
RxArray::at() const
{
	return send("at");
}

RxObject
RxArray::clear() const
{
	return send("clear");
}

RxObject
RxArray::collect_() const
{
	return send("collect!");
}

RxObject
RxArray::compact() const
{
	return send("compact");
}

RxObject
RxArray::compact_() const
{
	return send("compact!");
}

RxObject
RxArray::concat() const
{
	return send("concat");
}

RxObject
RxArray::delete_() const
{
	return send("delete");
}

RxObject
RxArray::delete_at() const
{
	return send("delete_at");
}

RxObject
RxArray::delete_if() const
{
	return send("delete_if");
}

RxObject
RxArray::each() const
{
	return send("each");
}

RxObject
RxArray::each_index() const
{
	return send("each_index");
}

RxObject
RxArray::empty_() const
{
	return send("empty?");
}

RxObject
RxArray::fill() const
{
	return send("fill");
}

RxObject
RxArray::filter() const
{
	return send("filter");
}

RxObject
RxArray::first() const
{
	return send("first");
}

RxObject
RxArray::flatten() const
{
	return send("flatten");
}

RxObject
RxArray::flatten_() const
{
	return send("flatten!");
}

RxObject
RxArray::index() const
{
	return send("index");
}

RxObject
RxArray::indexes() const
{
	return send("indexes");
}

RxObject
RxArray::indices() const
{
	return send("indices");
}

RxObject
RxArray::join() const
{
	return send("join");
}

RxObject
RxArray::last() const
{
	return send("last");
}

RxObject
RxArray::length() const
{
	return send("length");
}

RxObject
RxArray::map_() const
{
	return send("map!");
}

RxObject
RxArray::nitems() const
{
	return send("nitems");
}

RxObject
RxArray::pack() const
{
	return send("pack");
}

RxObject
RxArray::pop() const
{
	return RxObject(::rb_ary_pop(m_vObject));
}

RxObject
RxArray::push(RxObject obj) const
{
	return RxObject(::rb_ary_push(m_vObject, obj.value()));
}

RxObject
RxArray::rassoc() const
{
	return send("rassoc");
}

RxObject
RxArray::reject_() const
{
	return send("reject!");
}

RxObject
RxArray::replace() const
{
	return send("replace");
}

RxObject
RxArray::reverse() const
{
	return send("reverse");
}

RxObject
RxArray::reverse_() const
{
	return send("reverse!");
}

RxObject
RxArray::reverse_each() const
{
	return send("reverse_each");
}

RxObject
RxArray::rindex() const
{
	return send("rindex");
}

RxObject
RxArray::shift() const
{
	return send("shift");
}

RxObject
RxArray::size() const
{
	return send("size");
}

RxObject
RxArray::slice() const
{
	return send("slice");
}

RxObject
RxArray::slice_() const
{
	return send("slice!");
}

RxObject
RxArray::sort_() const
{
	return send("sort!");
}

RxObject
RxArray::to_ary() const
{
	return send("to_ary");
}

RxObject
RxArray::uniq() const
{
	return send("uniq");
}

RxObject
RxArray::uniq_() const
{
	return send("uniq!");
}

RxObject
RxArray::unshift() const
{
	return send("unshift");
}
