
#include "rubyxx/RxString.h"


RxString::RxString()
	: RxObject(::rb_str_new2(""))
{
}

RxString::RxString(RxObject& Object)
	: RxObject(Object)
{
}

RxString::RxString(const char* string)
	: RxObject(::rb_str_new2(string))
{
}

RxString::~RxString()
{
}


RxString::operator const char*() const
{
	return string();
}

const char*
RxString::string() const
{
	return STR2CSTR(m_vObject);
}


RxObject
RxString::between() const
{
	return send("between?");
}

RxObject
RxString::capitalize() const
{
	return send("capitalize");
}

RxObject
RxString::capitalize_() const
{
	return send("capitalize!");
}

RxObject
RxString::center() const
{
	return send("center");
}

RxObject
RxString::chomp() const
{
	return send("chomp");
}

RxObject
RxString::chomp_() const
{
	return send("chomp!");
}

RxObject
RxString::chop() const
{
	return send("chop");
}

RxObject
RxString::chop_() const
{
	return send("chop!");
}

RxObject
RxString::concat() const
{
	return send("concat");
}

RxObject
RxString::count() const
{
	return send("count");
}

RxObject
RxString::crypt() const
{
	return send("crypt");
}

RxObject
RxString::delete_() const
{
	return send("delete");
}

RxObject
RxString::delete__() const
{
	return send("delete!");
}

RxObject
RxString::downcase() const
{
	return send("downcase");
}

RxObject
RxString::downcase_() const
{
	return send("downcase!");
}

RxObject
RxString::dump() const
{
	return send("dump");
}

RxObject
RxString::each() const
{
	return send("each");
}

RxObject
RxString::each_byte() const
{
	return send("each_byte");
}

RxObject
RxString::each_line() const
{
	return send("each_line");
}

RxObject
RxString::empty_() const
{
	return send("empty");
}

RxObject
RxString::gsub() const
{
	return send("gsub");
}

RxObject
RxString::gsub_() const
{
	return send("gsub");
}

RxObject
RxString::hex() const
{
	return send("hex");
}

RxObject
RxString::index() const
{
	return send("index");
}

RxObject
RxString::intern() const
{
	return send("intern");
}

RxNumeric
RxString::length() const
{
	return send("length");
}

RxObject
RxString::ljust() const
{
	return send("ljust");
}

RxObject
RxString::next() const
{
	return send("next");
}

RxObject
RxString::next_() const
{
	return send("next!");
}

RxObject
RxString::oct() const
{
	return send("oct");
}

RxObject
RxString::replace() const
{
	return send("replace");
}

RxObject
RxString::reverse() const
{
	return send("reverse");
}

RxObject
RxString::reverse_() const
{
	return send("reverse!");
}

RxObject
RxString::rindex() const
{
	return send("rindex");
}

RxObject
RxString::rjust() const
{
	return send("rjust");
}

RxObject
RxString::scan() const
{
	return send("scan");
}

RxNumeric
RxString::size() const
{
	return send("size");
}

RxObject
RxString::slice() const
{
	return send("slice");
}

RxObject
RxString::slice_() const
{
	return send("slice!");
}

RxObject
RxString::split() const
{
	return send("split");
}

RxObject
RxString::squeeze() const
{
	return send("squeeze");
}

RxObject
RxString::squeeze_() const
{
	return send("squeeze!");
}

RxObject
RxString::strip() const
{
	return send("strip");
}

RxObject
RxString::strip_() const
{
	return send("strip!");
}

RxObject
RxString::sub() const
{
	return send("sub");
}

RxObject
RxString::sub_() const
{
	return send("sub");
}

RxObject
RxString::succ() const
{
	return send("succ");
}

RxObject
RxString::succ_() const
{
	return send("succ!");
}

RxObject
RxString::sum() const
{
	return send("sum");
}

RxObject
RxString::swapcase() const
{
	return send("swapcase");
}

RxObject
RxString::swapcase_() const
{
	return send("swapcase!");
}

RxObject
RxString::to_f() const
{
	return send("to_f");
}

RxObject
RxString::to_i() const
{
	return send("to_i");
}

RxObject
RxString::tr() const
{
	return send("tr");
}

RxObject
RxString::tr_() const
{
	return send("tr!");
}

RxObject
RxString::tr_s() const
{
	return send("tr_s");
}

RxObject
RxString::tr_s_() const
{
	return send("tr_s!");
}

RxObject
RxString::unpack() const
{
	return send("unpack");
}

RxObject
RxString::upcase() const
{
	return send("upcase");
}

RxObject
RxString::upcase_() const
{
	return send("upcase!");
}

RxObject
RxString::upto() const
{
	return send("upto");
}


RxObject
RxString::meta()
{
	return RxObject(rb_cString);
}
